/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.annotation.Message;

public class AnnotationMessageTypeResolver
implements MessageTypeResolver {
    private final MessageTypeResolver fallback;
    private final AnnotationSpecification specification;

    public AnnotationMessageTypeResolver() {
        this(new ClassBasedMessageTypeResolver(), AnnotationSpecification.DEFAULT);
    }

    public AnnotationMessageTypeResolver(@Nullable MessageTypeResolver fallback) {
        this(fallback, AnnotationSpecification.DEFAULT);
    }

    public AnnotationMessageTypeResolver(@Nullable MessageTypeResolver fallback, @Nonnull AnnotationSpecification specification) {
        this.fallback = fallback;
        this.specification = Objects.requireNonNull(specification, "The annotation specification may not be null.");
    }

    @Override
    public Optional<MessageType> resolve(@Nonnull Class<?> payloadType) {
        return AnnotationUtils.findAnnotationAttributes(payloadType, this.specification.annotation()).map(attributes -> new MessageType((String)attributes.get(this.specification.namespaceAttribute()), (String)attributes.get(this.specification.nameAttribute()), (String)attributes.get(this.specification.versionAttribute()))).or(() -> this.fallback != null ? this.fallback.resolve(payloadType) : Optional.empty());
    }

    public record AnnotationSpecification(@Nonnull Class<? extends Annotation> annotation, @Nonnull String nameAttribute, @Nonnull String versionAttribute, @Nullable String namespaceAttribute) {
        public static final AnnotationSpecification DEFAULT = new AnnotationSpecification(Message.class, "name", "version", "namespace");
    }
}

