/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.axonframework.common.Priority;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.AbstractAnnotatedParameterResolverFactory;
import org.axonframework.messaging.annotation.AggregateType;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Priority(value=0x3FFFFFFF)
public final class AggregateTypeParameterResolverFactory
extends AbstractAnnotatedParameterResolverFactory<AggregateType, String> {
    private final ParameterResolver<String> resolver = new AggregateTypeParameterResolver();

    public AggregateTypeParameterResolverFactory() {
        super(AggregateType.class, String.class);
    }

    @Override
    protected ParameterResolver<String> getResolver() {
        return this.resolver;
    }

    static class AggregateTypeParameterResolver
    implements ParameterResolver<String> {
        AggregateTypeParameterResolver() {
        }

        @Override
        @Nullable
        public String resolveParameterValue(@Nonnull ProcessingContext context) {
            Message message = Message.fromContext(context);
            if (message instanceof DomainEventMessage) {
                DomainEventMessage domainEventMessage = (DomainEventMessage)message;
                return domainEventMessage.getType();
            }
            return null;
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return Message.fromContext(context) instanceof DomainEventMessage;
        }
    }
}

