/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.axonframework.common.Assert;
import org.axonframework.common.StringUtils;
import org.axonframework.messaging.QualifiedName;

public record MessageType(@Nonnull QualifiedName qualifiedName, @Nonnull String version) {
    public static final String DEFAULT_VERSION = "0.0.1";
    private static final String VERSION_DELIMITER = "#";
    private static final String DEBUG_STRING_REGEX = "^([^#]+)#([^#]+)$";
    private static final Pattern DEBUG_STRING_PATTERN = Pattern.compile("^([^#]+)#([^#]+)$");
    private static final int QUALIFIED_NAME_GROUP = 1;
    private static final int VERSION_GROUP = 2;

    public MessageType {
        Objects.requireNonNull(qualifiedName, "The qualifiedName cannot be null.");
        Assert.assertThat(Objects.requireNonNull(version, "The given version is unsupported because it is null."), StringUtils::nonEmpty, () -> new IllegalArgumentException("The given version is unsupported because it is empty."));
    }

    public MessageType(@Nonnull QualifiedName name) {
        this(name, DEFAULT_VERSION);
    }

    public MessageType(@Nonnull String qualifiedName) {
        this(new QualifiedName(qualifiedName), DEFAULT_VERSION);
    }

    public MessageType(@Nonnull String qualifiedName, @Nonnull String version) {
        this(new QualifiedName(qualifiedName), version);
    }

    public MessageType(String namespace, @Nonnull String localName, @Nonnull String version) {
        this(new QualifiedName(namespace, localName), version);
    }

    public MessageType(@Nonnull Class<?> clazz, @Nonnull String version) {
        this(new QualifiedName(clazz), version);
    }

    public MessageType(@Nonnull Class<?> clazz) {
        this(clazz, DEFAULT_VERSION);
    }

    public String name() {
        return this.qualifiedName.toString();
    }

    public static MessageType fromString(@Nonnull String messageTypeString) {
        Matcher matcher = DEBUG_STRING_PATTERN.matcher(Objects.requireNonNull(messageTypeString, "Cannot construct a MessageType based on a null or empty String."));
        Assert.isTrue(matcher.matches(), () -> "The given simple String [" + messageTypeString + "] does not match the expected pattern.");
        return new MessageType(new QualifiedName(matcher.group(1)), matcher.group(2));
    }

    @Override
    public String toString() {
        return String.valueOf(this.qualifiedName) + VERSION_DELIMITER + this.version;
    }
}

