/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Map;
import org.axonframework.common.TypeReference;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.serialization.Converter;

public interface Message {
    public static final Context.ResourceKey<Message> RESOURCE_KEY = Context.ResourceKey.withLabel("Message");

    @Nonnull
    public static ProcessingContext addToContext(@Nonnull ProcessingContext context, @Nonnull Message message) {
        return context.withResource((Context.ResourceKey)RESOURCE_KEY, message);
    }

    @Nullable
    public static Message fromContext(@Nonnull ProcessingContext context) {
        return context.getResource(RESOURCE_KEY);
    }

    @Nonnull
    public String identifier();

    @Nonnull
    public MessageType type();

    @Nullable
    public Object payload();

    @Nullable
    default public <T> T payloadAs(@Nonnull Class<T> type, @Nullable Converter converter) {
        return this.payloadType().isAssignableFrom(type) ? type.cast(this.payload()) : this.payloadAs((Type)type, converter);
    }

    @Nullable
    default public <T> T payloadAs(@Nonnull Class<T> type) {
        return this.payloadAs(type, null);
    }

    @Nullable
    default public <T> T payloadAs(@Nonnull TypeReference<T> type, @Nullable Converter converter) {
        return this.payloadAs(type.getType(), converter);
    }

    @Nullable
    default public <T> T payloadAs(@Nonnull TypeReference<T> type) {
        return this.payloadAs(type.getTypeAsClass());
    }

    @Nullable
    public <T> T payloadAs(@Nonnull Type var1, @Nullable Converter var2);

    @Nonnull
    public Class<?> payloadType();

    @Nonnull
    public MetaData metaData();

    @Nonnull
    public Message withMetaData(@Nonnull Map<String, String> var1);

    @Nonnull
    public Message andMetaData(@Nonnull Map<String, String> var1);

    @Nonnull
    default public Message withConvertedPayload(@Nonnull Class<?> type, @Nonnull Converter converter) {
        return this.withConvertedPayload((Type)type, converter);
    }

    @Nonnull
    default public Message withConvertedPayload(@Nonnull TypeReference<?> type, @Nonnull Converter converter) {
        return this.withConvertedPayload(type.getType(), converter);
    }

    @Nonnull
    public Message withConvertedPayload(@Nonnull Type var1, @Nonnull Converter var2);
}

