/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.replay;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.ReplayStatus;
import org.axonframework.eventhandling.ReplayToken;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class ReplayParameterResolverFactory
implements ParameterResolverFactory {
    @Override
    @Nullable
    public ParameterResolver<ReplayStatus> createInstance(@Nonnull Executable executable, @Nonnull Parameter[] parameters, int parameterIndex) {
        if (ReplayStatus.class.isAssignableFrom(parameters[parameterIndex].getType())) {
            return new ReplayParameterResolver();
        }
        return null;
    }

    private static class ReplayParameterResolver
    implements ParameterResolver<ReplayStatus> {
        private ReplayParameterResolver() {
        }

        @Override
        @Nullable
        public ReplayStatus resolveParameterValue(@Nonnull ProcessingContext context) {
            Message message = Message.fromContext(context);
            if (message instanceof EventMessage) {
                EventMessage eventMessage = (EventMessage)message;
                return ReplayToken.isReplay(eventMessage) ? ReplayStatus.REPLAY : ReplayStatus.REGULAR;
            }
            return ReplayStatus.REGULAR;
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return Message.fromContext(context) instanceof EventMessage;
        }
    }
}

