/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jpa;

import java.time.Instant;
import java.util.Optional;
import java.util.function.Supplier;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.GenericTrackedDomainEventMessage;
import org.axonframework.eventhandling.GenericTrackedEventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.deadletter.jpa.DeadLetterEventEntry;
import org.axonframework.eventhandling.deadletter.jpa.DeadLetterJpaConverter;
import org.axonframework.messaging.MessageType;
import org.axonframework.serialization.SerializedMessage;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;

public class EventMessageDeadLetterJpaConverter
implements DeadLetterJpaConverter<EventMessage> {
    @Override
    public DeadLetterEventEntry convert(EventMessage message, Serializer eventSerializer, Serializer genericSerializer) {
        GenericEventMessage eventMessage = (GenericEventMessage)message;
        Optional<TrackedEventMessage> trackedEventMessage = Optional.of(eventMessage).filter(TrackedEventMessage.class::isInstance).map(TrackedEventMessage.class::cast);
        Optional<DomainEventMessage> domainEventMessage = Optional.of(eventMessage).filter(DomainEventMessage.class::isInstance).map(DomainEventMessage.class::cast);
        SerializedObject<byte[]> serializedPayload = eventSerializer.serialize(message.payload(), byte[].class);
        SerializedObject<byte[]> serializedMetadata = eventSerializer.serialize(message.metaData(), byte[].class);
        Optional<SerializedObject> serializedToken = trackedEventMessage.map(m -> genericSerializer.serialize(m.trackingToken(), byte[].class));
        return new DeadLetterEventEntry(message.getClass().getName(), message.identifier(), message.type().toString(), message.timestamp().toString(), serializedPayload.getType().getName(), serializedPayload.getType().getRevision(), serializedPayload.getData(), serializedMetadata.getData(), domainEventMessage.map(DomainEventMessage::getType).orElse(null), domainEventMessage.map(DomainEventMessage::getAggregateIdentifier).orElse(null), domainEventMessage.map(DomainEventMessage::getSequenceNumber).orElse(null), serializedToken.map(SerializedObject::getType).map(SerializedType::getName).orElse(null), serializedToken.map(SerializedObject::getData).orElse(null));
    }

    @Override
    public EventMessage convert(DeadLetterEventEntry entry, Serializer eventSerializer, Serializer genericSerializer) {
        SerializedMessage serializedMessage = new SerializedMessage(entry.getEventIdentifier(), entry.getPayload(), entry.getMetaData(), eventSerializer);
        Supplier<Instant> timestampSupplier = () -> Instant.parse(entry.getTimeStamp());
        if (entry.getTrackingToken() != null) {
            TrackingToken trackingToken = (TrackingToken)genericSerializer.deserialize(entry.getTrackingToken());
            if (entry.getAggregateIdentifier() != null) {
                return new GenericTrackedDomainEventMessage(trackingToken, entry.getAggregateType(), entry.getAggregateIdentifier(), (long)entry.getSequenceNumber(), serializedMessage, timestampSupplier);
            }
            return new GenericTrackedEventMessage(trackingToken, serializedMessage, timestampSupplier);
        }
        if (entry.getAggregateIdentifier() != null) {
            return new GenericDomainEventMessage(entry.getAggregateType(), entry.getAggregateIdentifier(), entry.getSequenceNumber(), serializedMessage.identifier(), MessageType.fromString(entry.getType()), serializedMessage.payload(), serializedMessage.metaData(), timestampSupplier.get());
        }
        return new GenericEventMessage(serializedMessage, timestampSupplier);
    }

    @Override
    public boolean canConvert(DeadLetterEventEntry message) {
        return message.getEventType().equals(GenericTrackedDomainEventMessage.class.getName()) || message.getEventType().equals(GenericEventMessage.class.getName()) || message.getEventType().equals(GenericDomainEventMessage.class.getName()) || message.getEventType().equals(GenericTrackedEventMessage.class.getName());
    }

    @Override
    public boolean canConvert(EventMessage message) {
        return message instanceof GenericEventMessage;
    }
}

