/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.configuration;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventHandlingComponent;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.messaging.QualifiedName;

public interface EventHandlingComponentBuilder {

    public static interface CompletePhase {
        @Nonnull
        public CompletePhase decorated(@Nonnull UnaryOperator<EventHandlingComponent> var1);

        @Nonnull
        public EventHandlingComponent build();
    }

    public static interface AdditionalEventHandlerPhase
    extends CompletePhase {
        @Nonnull
        public AdditionalEventHandlerPhase handles(@Nonnull QualifiedName var1, @Nonnull EventHandler var2);

        @Nonnull
        public AdditionalEventHandlerPhase handles(@Nonnull Set<QualifiedName> var1, @Nonnull EventHandler var2);
    }

    public static interface RequiredEventHandlerPhase {
        @Nonnull
        public AdditionalEventHandlerPhase handles(@Nonnull QualifiedName var1, @Nonnull EventHandler var2);

        @Nonnull
        public AdditionalEventHandlerPhase handles(@Nonnull Set<QualifiedName> var1, @Nonnull EventHandler var2);
    }

    public static interface SequencingPolicyPhase
    extends RequiredEventHandlerPhase {
        @Nonnull
        public RequiredEventHandlerPhase sequencingPolicy(@Nonnull SequencingPolicy var1);

        @Nonnull
        default public RequiredEventHandlerPhase sequenceIdentifier(@Nonnull Function<EventMessage, Object> sequencingPolicy) {
            return this.sequencingPolicy((event, context) -> Optional.of(sequencingPolicy.apply(event)));
        }
    }
}

