/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.StringJoiner;
import org.axonframework.common.Assert;
import org.axonframework.eventhandling.TrackingToken;

public class MultiSourceTrackingToken
implements TrackingToken {
    @JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS)
    private final Map<String, TrackingToken> trackingTokens;

    @JsonCreator
    @ConstructorProperties(value={"trackingTokens"})
    public MultiSourceTrackingToken(@JsonProperty(value="trackingTokens") Map<String, TrackingToken> trackingTokens) {
        this.trackingTokens = trackingTokens;
    }

    @Override
    public TrackingToken lowerBound(TrackingToken other) {
        Assert.isTrue(other instanceof MultiSourceTrackingToken, () -> "Incompatible token type provided.");
        MultiSourceTrackingToken otherMultiToken = (MultiSourceTrackingToken)other;
        Assert.isTrue(otherMultiToken.trackingTokens.keySet().equals(this.trackingTokens.keySet()), () -> "MultiSourceTrackingTokens contain different keys");
        HashMap<String, TrackingToken> tokenMap = new HashMap<String, TrackingToken>();
        otherMultiToken.trackingTokens.forEach((tokenSourceName, otherToken) -> {
            TrackingToken thisToken = this.trackingTokens.get(tokenSourceName);
            tokenMap.put((String)tokenSourceName, thisToken == null || otherToken == null ? null : thisToken.lowerBound((TrackingToken)otherToken));
        });
        return new MultiSourceTrackingToken(tokenMap);
    }

    @Override
    public TrackingToken upperBound(TrackingToken other) {
        Assert.isTrue(other instanceof MultiSourceTrackingToken, () -> "Incompatible token type provided.");
        MultiSourceTrackingToken otherMultiToken = (MultiSourceTrackingToken)other;
        Assert.isTrue(otherMultiToken.trackingTokens.keySet().equals(this.trackingTokens.keySet()), () -> "MultiSourceTrackingTokens contain different keys");
        HashMap<String, TrackingToken> tokenMap = new HashMap<String, TrackingToken>();
        otherMultiToken.trackingTokens.forEach((tokenSourceName, otherToken) -> tokenMap.put((String)tokenSourceName, this.getUpperBound(this.trackingTokens.get(tokenSourceName), (TrackingToken)otherToken)));
        return new MultiSourceTrackingToken(tokenMap);
    }

    private TrackingToken getUpperBound(TrackingToken thisToken, TrackingToken otherToken) {
        if (thisToken == null) {
            return otherToken;
        }
        if (otherToken == null) {
            return thisToken;
        }
        return thisToken.upperBound(otherToken);
    }

    @Override
    public boolean covers(TrackingToken other) {
        Assert.isTrue(other instanceof MultiSourceTrackingToken, () -> "Incompatible token type provided.");
        MultiSourceTrackingToken otherMultiToken = (MultiSourceTrackingToken)other;
        Assert.isTrue(otherMultiToken.trackingTokens.keySet().equals(this.trackingTokens.keySet()), () -> "MultiSourceTrackingTokens contain different keys");
        for (Map.Entry<String, TrackingToken> trackingTokenEntry : this.trackingTokens.entrySet()) {
            TrackingToken constituent = trackingTokenEntry.getValue();
            TrackingToken otherConstituent = otherMultiToken.trackingTokens.get(trackingTokenEntry.getKey());
            if (!(constituent == null ? otherConstituent != null : otherConstituent != null && !constituent.covers(otherConstituent))) continue;
            return false;
        }
        return true;
    }

    public MultiSourceTrackingToken advancedTo(String streamName, TrackingToken newTokenForStream) {
        HashMap<String, TrackingToken> newTrackingTokens = new HashMap<String, TrackingToken>(this.trackingTokens);
        newTrackingTokens.put(streamName, newTokenForStream);
        return new MultiSourceTrackingToken(newTrackingTokens);
    }

    public TrackingToken getTokenForStream(String streamName) {
        return this.trackingTokens.get(streamName);
    }

    public Map<String, TrackingToken> getTrackingTokens() {
        return this.trackingTokens;
    }

    @Override
    public OptionalLong position() {
        if (this.trackingTokens.entrySet().stream().noneMatch(token -> token.getValue() != null && ((TrackingToken)token.getValue()).position().isPresent())) {
            return OptionalLong.empty();
        }
        long sumOfTokens = this.trackingTokens.values().stream().filter(Objects::nonNull).mapToLong(trackingToken -> trackingToken.position().orElse(0L)).sum();
        return OptionalLong.of(sumOfTokens);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiSourceTrackingToken that = (MultiSourceTrackingToken)o;
        if (this.trackingTokens.size() != that.trackingTokens.size()) {
            return false;
        }
        return this.trackingTokens.entrySet().stream().allMatch(trackingTokenEntry -> Objects.equals(trackingTokenEntry.getValue(), that.trackingTokens.get(trackingTokenEntry.getKey())));
    }

    public int hashCode() {
        return Objects.hash(this.trackingTokens);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(",", "MultiSourceTrackingToken{", "}");
        this.trackingTokens.forEach((name, token) -> joiner.add(String.format("%s=%s", name, token)));
        return joiner.toString();
    }
}

