/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;
import org.axonframework.common.ObjectUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDecorator;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.CachingSupplier;
import org.axonframework.serialization.Converter;

public class GenericEventMessage
extends MessageDecorator
implements EventMessage {
    private final Supplier<Instant> timestampSupplier;
    @Deprecated
    public static Clock clock = Clock.systemUTC();

    public GenericEventMessage(@Nonnull MessageType type, @Nullable Object payload) {
        this(type, payload, MetaData.emptyInstance());
    }

    public GenericEventMessage(@Nonnull MessageType type, @Nullable Object payload, @Nonnull Map<String, String> metaData) {
        this((Message)new GenericMessage(type, payload, metaData), clock.instant());
    }

    public GenericEventMessage(@Nonnull String identifier, @Nonnull MessageType type, @Nullable Object payload, @Nonnull Map<String, String> metaData, @Nonnull Instant timestamp) {
        this((Message)new GenericMessage(identifier, type, payload, metaData), timestamp);
    }

    public GenericEventMessage(@Nonnull Message delegate, @Nonnull Supplier<Instant> timestampSupplier) {
        super(delegate);
        this.timestampSupplier = CachingSupplier.of(timestampSupplier);
    }

    protected GenericEventMessage(@Nonnull Message delegate, @Nonnull Instant timestamp) {
        this(delegate, CachingSupplier.of(timestamp));
    }

    @Override
    @Nonnull
    public Instant timestamp() {
        return this.timestampSupplier.get();
    }

    @Override
    @Nonnull
    public EventMessage withMetaData(@Nonnull Map<String, String> metaData) {
        if (this.metaData().equals(metaData)) {
            return this;
        }
        return new GenericEventMessage(this.delegate().withMetaData(metaData), this.timestampSupplier);
    }

    @Override
    @Nonnull
    public EventMessage andMetaData(@Nonnull Map<String, String> metaData) {
        if (metaData == null || metaData.isEmpty() || this.metaData().equals(metaData)) {
            return this;
        }
        return new GenericEventMessage(this.delegate().andMetaData(metaData), this.timestampSupplier);
    }

    @Override
    @Nonnull
    public EventMessage withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        Object convertedPayload = this.payloadAs(type, converter);
        if (ObjectUtils.nullSafeTypeOf(convertedPayload).isAssignableFrom(this.payloadType())) {
            return this;
        }
        Message delegate = this.delegate();
        GenericMessage converted = new GenericMessage(delegate.identifier(), delegate.type(), convertedPayload, delegate.metaData());
        return new GenericEventMessage((Message)converted, this.timestamp());
    }

    @Override
    protected void describeTo(StringBuilder stringBuilder) {
        super.describeTo(stringBuilder);
        stringBuilder.append(", timestamp='").append(this.timestamp());
    }

    @Override
    protected String describeType() {
        return "GenericEventMessage";
    }
}

