/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandPriorityCalculator;
import org.axonframework.commandhandling.RoutingStrategy;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.annotation.AnnotationRoutingStrategy;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.ConvertingCommandGateway;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.conversion.DelegatingEventConverter;
import org.axonframework.eventhandling.conversion.EventConverter;
import org.axonframework.eventhandling.gateway.DefaultEventGateway;
import org.axonframework.eventhandling.gateway.EventGateway;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.ConfigurationApplicationContext;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.conversion.DelegatingMessageConverter;
import org.axonframework.messaging.conversion.MessageConverter;
import org.axonframework.messaging.unitofwork.SimpleUnitOfWorkFactory;
import org.axonframework.messaging.unitofwork.TransactionalUnitOfWorkFactory;
import org.axonframework.messaging.unitofwork.UnitOfWorkFactory;
import org.axonframework.queryhandling.DefaultQueryGateway;
import org.axonframework.queryhandling.LoggingQueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.SimpleQueryBus;
import org.axonframework.queryhandling.SimpleQueryUpdateEmitter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.json.JacksonConverter;

public class MessagingConfigurationDefaults
implements ConfigurationEnhancer {
    public static final int CONVERTING_COMMAND_GATEWAY_ORDER = -2147483548;

    @Override
    public int order() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void enhance(@Nonnull ComponentRegistry registry) {
        registry.registerIfNotPresent(MessageTypeResolver.class, MessagingConfigurationDefaults::defaultMessageTypeResolver).registerIfNotPresent(Converter.class, c -> new JacksonConverter()).registerIfNotPresent(MessageConverter.class, MessagingConfigurationDefaults::defaultMessageConverter).registerIfNotPresent(EventConverter.class, MessagingConfigurationDefaults::defaultEventConverter).registerIfNotPresent(UnitOfWorkFactory.class, MessagingConfigurationDefaults::defaultUnitOfWorkFactory).registerIfNotPresent(CommandGateway.class, MessagingConfigurationDefaults::defaultCommandGateway).registerIfNotPresent(CommandBus.class, MessagingConfigurationDefaults::defaultCommandBus).registerIfNotPresent(RoutingStrategy.class, MessagingConfigurationDefaults::defaultRoutingStrategy).registerIfNotPresent(EventGateway.class, MessagingConfigurationDefaults::defaultEventGateway).registerIfNotPresent(EventSink.class, MessagingConfigurationDefaults::defaultEventSink).registerIfNotPresent(EventBus.class, MessagingConfigurationDefaults::defaultEventBus).registerIfNotPresent(QueryGateway.class, MessagingConfigurationDefaults::defaultQueryGateway).registerIfNotPresent(QueryBus.class, MessagingConfigurationDefaults::defaultQueryBus).registerIfNotPresent(QueryUpdateEmitter.class, MessagingConfigurationDefaults::defaultQueryUpdateEmitter);
        registry.registerDecorator(CommandGateway.class, -2147483548, (config, name, delegate) -> new ConvertingCommandGateway((CommandGateway)delegate, config.getComponent(MessageConverter.class)));
    }

    private static MessageTypeResolver defaultMessageTypeResolver(Configuration config) {
        return new ClassBasedMessageTypeResolver();
    }

    private static DelegatingMessageConverter defaultMessageConverter(Configuration c) {
        return new DelegatingMessageConverter(c.getComponent(Converter.class));
    }

    private static DelegatingEventConverter defaultEventConverter(Configuration c) {
        return c.getOptionalComponent(MessageConverter.class).map(DelegatingEventConverter::new).orElse(new DelegatingEventConverter(c.getComponent(Converter.class)));
    }

    private static UnitOfWorkFactory defaultUnitOfWorkFactory(Configuration config) {
        return new TransactionalUnitOfWorkFactory(config.getComponent(TransactionManager.class, NoTransactionManager::instance), new SimpleUnitOfWorkFactory(new ConfigurationApplicationContext(config)));
    }

    private static CommandBus defaultCommandBus(Configuration config) {
        return new SimpleCommandBus(config.getComponent(UnitOfWorkFactory.class), config.getOptionalComponent(TransactionManager.class).map(tm -> tm).map(List::of).orElse(Collections.emptyList()));
    }

    private static CommandGateway defaultCommandGateway(Configuration config) {
        return new DefaultCommandGateway(config.getComponent(CommandBus.class), config.getComponent(MessageTypeResolver.class), config.getOptionalComponent(CommandPriorityCalculator.class).orElse(null), config.getOptionalComponent(RoutingStrategy.class).orElse(null));
    }

    private static EventBus defaultEventBus(Configuration config) {
        return SimpleEventBus.builder().build();
    }

    private static EventSink defaultEventSink(Configuration config) {
        EventBus eventBus = config.getComponent(EventBus.class);
        return (context, events) -> {
            eventBus.publish(events);
            return FutureUtils.emptyCompletedFuture();
        };
    }

    private static EventGateway defaultEventGateway(Configuration config) {
        return new DefaultEventGateway(config.getComponent(EventSink.class), config.getComponent(MessageTypeResolver.class));
    }

    private static QueryGateway defaultQueryGateway(Configuration config) {
        return DefaultQueryGateway.builder().queryBus(config.getComponent(QueryBus.class)).build();
    }

    private static QueryBus defaultQueryBus(Configuration config) {
        return SimpleQueryBus.builder().transactionManager(config.getComponent(TransactionManager.class, NoTransactionManager::instance)).errorHandler(config.getComponent(QueryInvocationErrorHandler.class, () -> LoggingQueryInvocationErrorHandler.builder().build())).queryUpdateEmitter(config.getComponent(QueryUpdateEmitter.class)).build();
    }

    private static QueryUpdateEmitter defaultQueryUpdateEmitter(Configuration config) {
        return SimpleQueryUpdateEmitter.builder().build();
    }

    private static RoutingStrategy defaultRoutingStrategy(Configuration config) {
        return new AnnotationRoutingStrategy();
    }
}

