/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import jakarta.annotation.Nonnull;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

public abstract class TypeReference<E> {
    protected final Type type;

    protected TypeReference() {
        Type superClass = this.getClass().getGenericSuperclass();
        if (superClass instanceof Class) {
            throw new IllegalArgumentException("Internal error: TypeReference constructed without actual type information");
        }
        this.type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
    }

    private TypeReference(@Nonnull Type type) {
        this.type = Objects.requireNonNull(type, "The given type may not be null.");
    }

    public static <C> TypeReference<C> fromType(@Nonnull Class<C> type) {
        return new TypeReference<C>(type){};
    }

    @Nonnull
    public Class<E> getTypeAsClass() {
        Type type = this.type;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        type = this.type;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        throw new IllegalArgumentException("Internal error: TypeReference constructed with unsupported type: %s".formatted(this.type));
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeReference that = (TypeReference)o;
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hashCode(this.type);
    }
}

