/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import jakarta.annotation.Nonnull;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.distributed.CommandBusConnector;
import org.axonframework.commandhandling.distributed.DistributedCommandBus;
import org.axonframework.commandhandling.distributed.DistributedCommandBusConfiguration;
import org.axonframework.common.annotation.Internal;
import org.axonframework.configuration.ComponentDecorator;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.configuration.DecoratorDefinition;
import org.axonframework.configuration.SearchScope;

@Internal
public class DistributedCommandBusConfigurationEnhancer
implements ConfigurationEnhancer {
    public static final int DISTRIBUTED_COMMAND_BUS_ORDER = -1;

    @Override
    public void enhance(@Nonnull ComponentRegistry componentRegistry) {
        if (componentRegistry.hasComponent(CommandBusConnector.class)) {
            componentRegistry.registerIfNotPresent(DistributedCommandBusConfiguration.class, c -> DistributedCommandBusConfiguration.DEFAULT, SearchScope.ALL).registerDecorator(DecoratorDefinition.forType(CommandBus.class).with(this.commandBusDecoratorDefinition()).order(-1));
        }
    }

    private ComponentDecorator<CommandBus, CommandBus> commandBusDecoratorDefinition() {
        return (config, name, delegate) -> {
            if (delegate instanceof DistributedCommandBus) {
                return delegate;
            }
            DistributedCommandBusConfiguration commandBusConfiguration = config.getComponent(DistributedCommandBusConfiguration.class);
            return config.getOptionalComponent(CommandBusConnector.class).map(connector -> new DistributedCommandBus((CommandBus)delegate, (CommandBusConnector)connector, commandBusConfiguration)).orElse((CommandBus)delegate);
        };
    }
}

