/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.common.ObjectUtils;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDecorator;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.Converter;

public class GenericCommandMessage
extends MessageDecorator
implements CommandMessage {
    private final String routingKey;
    private final Integer priority;

    public GenericCommandMessage(@Nonnull MessageType type, @Nullable Object payload) {
        this(type, payload, MetaData.emptyInstance());
    }

    public GenericCommandMessage(@Nonnull MessageType type, @Nullable Object payload, @Nonnull Map<String, String> metaData) {
        this(new GenericMessage(type, payload, metaData));
    }

    public GenericCommandMessage(@Nonnull MessageType type, @Nonnull Object payload, @Nonnull Map<String, String> metaData, @Nullable String routingKey, @Nullable Integer priority) {
        this(new GenericMessage(type, payload, metaData), routingKey, priority);
    }

    public GenericCommandMessage(@Nonnull Message delegate) {
        this(delegate, null, null);
    }

    public GenericCommandMessage(@Nonnull Message delegate, @Nullable String routingKey, @Nullable Integer priority) {
        super(delegate);
        this.routingKey = routingKey;
        this.priority = priority;
    }

    @Override
    public Optional<String> routingKey() {
        return Optional.ofNullable(this.routingKey);
    }

    @Override
    public OptionalInt priority() {
        if (this.priority == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this.priority);
    }

    @Override
    @Nonnull
    public CommandMessage withMetaData(@Nonnull Map<String, String> metaData) {
        return new GenericCommandMessage(this.delegate().withMetaData(metaData));
    }

    @Override
    @Nonnull
    public CommandMessage andMetaData(@Nonnull Map<String, String> metaData) {
        return new GenericCommandMessage(this.delegate().andMetaData(metaData));
    }

    @Override
    @Nonnull
    public CommandMessage withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        Object convertedPayload = this.payloadAs(type, converter);
        if (ObjectUtils.nullSafeTypeOf(convertedPayload).isAssignableFrom(this.payloadType())) {
            return this;
        }
        Message delegate = this.delegate();
        GenericMessage converted = new GenericMessage(delegate.identifier(), delegate.type(), convertedPayload, delegate.metaData());
        return new GenericCommandMessage(converted, this.routingKey, this.priority);
    }

    @Override
    protected String describeType() {
        return "GenericCommandMessage";
    }
}

