/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.common.annotation.Internal;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptorChain;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Internal
public class CommandMessageHandlerInterceptorChain
implements MessageHandlerInterceptorChain<CommandMessage> {
    private final CommandHandler interceptingHandler;

    public CommandMessageHandlerInterceptorChain(@Nonnull List<MessageHandlerInterceptor<CommandMessage>> interceptors, @Nonnull CommandHandler commandHandler) {
        Iterator<MessageHandlerInterceptor<CommandMessage>> interceptorIterator = new LinkedList<MessageHandlerInterceptor<CommandMessage>>(interceptors).descendingIterator();
        CommandHandler handler = Objects.requireNonNull(commandHandler, "The Command Handler may not be null.");
        while (interceptorIterator.hasNext()) {
            handler = new InterceptingHandler(interceptorIterator.next(), handler);
        }
        this.interceptingHandler = handler;
    }

    @Override
    @Nonnull
    public MessageStream<?> proceed(@Nonnull CommandMessage command, @Nonnull ProcessingContext context) {
        try {
            return this.interceptingHandler.handle(command, context);
        }
        catch (Exception e) {
            return MessageStream.failed(e);
        }
    }

    private record InterceptingHandler(MessageHandlerInterceptor<? super CommandMessage> interceptor, CommandHandler next) implements CommandHandler,
    MessageHandlerInterceptorChain<CommandMessage>
    {
        @Override
        @Nonnull
        public MessageStream.Single<CommandResultMessage<?>> handle(@Nonnull CommandMessage command, @Nonnull ProcessingContext context) {
            return this.interceptor.interceptOnHandle(command, context, this).first();
        }

        @Override
        @Nonnull
        public MessageStream<?> proceed(@Nonnull CommandMessage command, @Nonnull ProcessingContext context) {
            return this.next.handle(command, context);
        }
    }
}

