/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates.detection;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import org.axonframework.common.annotation.Internal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class MachineId {
    private static final Logger logger = LoggerFactory.getLogger(MachineId.class);
    private static final String MACHINE_ID_PATH = "/.axoniq/.machine-id";
    private String machineId;

    public MachineId() {
        this.initialize();
    }

    public String get() {
        return this.machineId;
    }

    private void initialize() {
        try {
            File file = this.getFile();
            if (file.exists()) {
                this.machineId = new String(Files.readAllBytes(file.toPath()));
                return;
            }
            File parentDir = this.getFile().getParentFile();
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                throw new IOException("Failed to create parent directory: " + parentDir.getAbsolutePath());
            }
            this.machineId = UUID.randomUUID().toString();
            Files.writeString(file.toPath(), (CharSequence)this.machineId, new OpenOption[0]);
        }
        catch (Exception e) {
            logger.debug("Failed to initialize machine id", (Throwable)e);
        }
    }

    private File getFile() {
        String pwdDir = System.getProperty("user.home");
        String installationIdFilePath = pwdDir + MACHINE_ID_PATH;
        return new File(installationIdFilePath);
    }
}

