/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.axonframework.serialization.ContentTypeConverter;
import org.axonframework.serialization.ConversionException;

public class JsonNodeToObjectNodeConverter
implements ContentTypeConverter<JsonNode, ObjectNode> {
    @Override
    @Nonnull
    public Class<JsonNode> expectedSourceType() {
        return JsonNode.class;
    }

    @Override
    @Nonnull
    public Class<ObjectNode> targetType() {
        return ObjectNode.class;
    }

    @Override
    @Nullable
    public ObjectNode convert(@Nullable JsonNode input) {
        if (input == null) {
            return null;
        }
        JsonNodeType originalNodeType = input.getNodeType();
        if (JsonNodeType.OBJECT.equals((Object)originalNodeType)) {
            return (ObjectNode)input;
        }
        throw new ConversionException("Cannot convert from JsonNode to ObjectNode because the node type is [" + String.valueOf(originalNodeType) + "].");
    }
}

