/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.QueryHandlingComponent;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;

public class SimpleQueryHandlingComponent
implements QueryHandlingComponent {
    private final ConcurrentHashMap<QualifiedName, QueryHandler> queryHandlers = new ConcurrentHashMap();

    @Override
    @Nonnull
    public MessageStream<QueryResponseMessage<?>> handle(@Nonnull QueryMessage<?, ?> query, @Nonnull ProcessingContext context) {
        QualifiedName name = query.type().qualifiedName();
        QueryHandler handler = this.queryHandlers.get(name);
        if (handler == null) {
            return MessageStream.failed(new IllegalArgumentException("No handler found for query with name [" + String.valueOf(name) + "]"));
        }
        return handler.handle(query, context);
    }

    @Override
    public SimpleQueryHandlingComponent subscribe(@Nonnull Set<QualifiedName> names, @Nonnull QueryHandler handler) {
        names.forEach(name -> this.queryHandlers.put((QualifiedName)name, Objects.requireNonNull(handler, "TODO")));
        return this;
    }

    @Override
    public SimpleQueryHandlingComponent subscribe(@Nonnull QualifiedName name, @Nonnull QueryHandler handler) {
        return this.subscribe((Set)Set.of(name), handler);
    }

    @Override
    public Set<QualifiedName> supportedQueries() {
        return Set.copyOf(this.queryHandlers.keySet());
    }
}

