/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import jakarta.annotation.Nonnull;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.queryhandling.QueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingQueryInvocationErrorHandler
implements QueryInvocationErrorHandler {
    private final Logger logger;

    protected LoggingQueryInvocationErrorHandler(Builder builder) {
        builder.validate();
        this.logger = builder.logger;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void onError(@Nonnull Throwable error, @Nonnull QueryMessage<?, ?> queryMessage, @Nonnull MessageHandler messageHandler) {
        this.logger.warn("An error occurred while processing query message [{}]", (Object)queryMessage.type(), (Object)error);
    }

    public static class Builder {
        private Logger logger = LoggerFactory.getLogger(LoggingQueryInvocationErrorHandler.class);

        public Builder logger(Logger logger) {
            BuilderUtils.assertNonNull(logger, "Logger may not be null");
            this.logger = logger;
            return this;
        }

        public LoggingQueryInvocationErrorHandler build() {
            return new LoggingQueryInvocationErrorHandler(this);
        }

        protected void validate() throws AxonConfigurationException {
        }
    }
}

