/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.monitoring;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.axonframework.common.Assert;
import org.axonframework.messaging.Message;
import org.axonframework.monitoring.MessageMonitor;

public class MultiMessageMonitor<T extends Message<?>>
implements MessageMonitor<T> {
    private final List<MessageMonitor<? super T>> messageMonitors;

    @SafeVarargs
    public MultiMessageMonitor(MessageMonitor<? super T> ... messageMonitors) {
        this(Arrays.asList(messageMonitors));
    }

    public MultiMessageMonitor(List<MessageMonitor<? super T>> messageMonitors) {
        Assert.notNull(messageMonitors, () -> "MessageMonitor list may not be null");
        this.messageMonitors = new ArrayList<MessageMonitor<T>>(messageMonitors);
    }

    @Override
    public MessageMonitor.MonitorCallback onMessageIngested(@Nonnull T message) {
        final List monitorCallbacks = this.messageMonitors.stream().map(messageMonitor -> messageMonitor.onMessageIngested(message)).collect(Collectors.toList());
        return new MessageMonitor.MonitorCallback(){

            @Override
            public void reportSuccess() {
                monitorCallbacks.forEach(MessageMonitor.MonitorCallback::reportSuccess);
            }

            @Override
            public void reportFailure(Throwable cause) {
                monitorCallbacks.forEach(resultCallback -> resultCallback.reportFailure(cause));
            }

            @Override
            public void reportIgnored() {
                monitorCallbacks.forEach(MessageMonitor.MonitorCallback::reportIgnored);
            }
        };
    }
}

