/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.timeout;

import jakarta.annotation.Nonnull;
import java.util.concurrent.ScheduledExecutorService;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.timeout.AxonTaskJanitor;
import org.axonframework.messaging.timeout.AxonTimeLimitedTask;
import org.axonframework.messaging.unitofwork.LegacyUnitOfWork;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.slf4j.Logger;

public class UnitOfWorkTimeoutInterceptor
implements MessageHandlerInterceptor<Message<?>> {
    private static final String TRANSACTION_TIME_LIMIT_RESOURCE_KEY = "_transactionTimeLimit";
    private static final Context.ResourceKey<AxonTimeLimitedTask> TRANSACTION_TIME_LIMIT_CONTEXT_RESOURCE_KEY = Context.ResourceKey.withLabel("_transactionTimeLimit");
    private final String componentName;
    private final int timeout;
    private final int warningThreshold;
    private final int warningInterval;
    private final ScheduledExecutorService executorService;
    private final Logger logger;

    public UnitOfWorkTimeoutInterceptor(String componentName, int timeout, int warningThreshold, int warningInterval) {
        this(componentName, timeout, warningThreshold, warningInterval, AxonTaskJanitor.INSTANCE, AxonTaskJanitor.LOGGER);
    }

    public UnitOfWorkTimeoutInterceptor(String componentName, int timeout, int warningThreshold, int warningInterval, ScheduledExecutorService executorService, Logger logger) {
        this.componentName = componentName;
        this.timeout = timeout;
        this.warningThreshold = warningThreshold;
        this.warningInterval = warningInterval;
        this.executorService = executorService;
        this.logger = logger;
    }

    @Override
    public Object handle(@Nonnull LegacyUnitOfWork<? extends Message<?>> unitOfWork, @Nonnull ProcessingContext context, @Nonnull InterceptorChain interceptorChain) throws Exception {
        LegacyUnitOfWork<?> root = unitOfWork.root();
        if (!root.resources().containsKey(TRANSACTION_TIME_LIMIT_RESOURCE_KEY)) {
            AxonTimeLimitedTask taskTimeout = this.taskTimeout();
            root.resources().put(TRANSACTION_TIME_LIMIT_RESOURCE_KEY, taskTimeout);
            taskTimeout.start();
            unitOfWork.afterCommit(u -> taskTimeout.complete());
            unitOfWork.onRollback(u -> taskTimeout.complete());
        }
        return interceptorChain.proceedSync(context);
    }

    @Override
    public <M extends Message<?>, R extends Message<?>> MessageStream<R> interceptOnHandle(@Nonnull M message, @Nonnull ProcessingContext context, @Nonnull InterceptorChain<M, R> interceptorChain) {
        if (!context.containsResource(TRANSACTION_TIME_LIMIT_CONTEXT_RESOURCE_KEY)) {
            AxonTimeLimitedTask taskTimeout = this.taskTimeout();
            context.putResource(TRANSACTION_TIME_LIMIT_CONTEXT_RESOURCE_KEY, taskTimeout);
            taskTimeout.start();
            context.runOnAfterCommit(u -> taskTimeout.complete());
            context.onError((ctx, phase, error) -> taskTimeout.complete());
        }
        return interceptorChain.proceed(message, context);
    }

    private AxonTimeLimitedTask taskTimeout() {
        return new AxonTimeLimitedTask("UnitOfWork of " + this.componentName, this.timeout, this.warningThreshold, this.warningInterval, this.executorService, this.logger);
    }
}

