/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.timeout;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.axonframework.messaging.timeout.AxonTaskJanitor;
import org.slf4j.Logger;

class AxonTimeLimitedTask {
    private final Thread thread;
    private final int timeout;
    private final int warningThreshold;
    private final int warningInterval;
    private final String taskName;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Logger logger;
    private boolean completed = false;
    private boolean interrupted = false;
    private long startTimeMs = -1L;
    private Future<?> currentScheduledFuture = null;
    private String startStackTrace;

    public AxonTimeLimitedTask(String taskName, int timeout, int warningThreshold, int warningInterval) {
        this(taskName, timeout, warningThreshold, warningInterval, AxonTaskJanitor.INSTANCE, AxonTaskJanitor.LOGGER);
    }

    public AxonTimeLimitedTask(String taskName, int timeout, int warningThreshold, int warningInterval, ScheduledExecutorService scheduledExecutorService, Logger logger) {
        if (taskName == null || taskName.isEmpty()) {
            throw new IllegalArgumentException("Task name cannot be null or empty");
        }
        this.taskName = taskName;
        this.timeout = timeout;
        this.warningThreshold = warningThreshold;
        this.warningInterval = warningInterval;
        this.scheduledExecutorService = scheduledExecutorService;
        this.logger = logger;
        this.thread = Thread.currentThread();
    }

    public void start() {
        if (this.startTimeMs != -1L) {
            throw new IllegalStateException("Task can only be run once");
        }
        this.startTimeMs = System.currentTimeMillis();
        this.startStackTrace = this.thread.getStackTrace()[2].getClassName();
        if (this.warningThreshold < 0 || this.warningThreshold >= this.timeout) {
            this.scheduleImmediateInterrupt();
        } else {
            this.scheduleFirstWarning();
        }
    }

    public void complete() {
        this.completed = true;
        if (this.currentScheduledFuture != null) {
            this.currentScheduledFuture.cancel(false);
            this.currentScheduledFuture = null;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("{} completed", (Object)this.taskName);
        }
    }

    private void scheduleImmediateInterrupt() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("{} will be interrupted after [{}ms]", (Object)this.taskName, (Object)this.timeout);
        }
        this.scheduleInterrupt(this.timeout);
    }

    private void scheduleFirstWarning() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("{} will be interrupted in [{}ms]. First warning will be issued in [{}ms].", new Object[]{this.taskName, this.timeout, this.warningThreshold});
        }
        this.scheduleWarning(this.warningThreshold);
    }

    private void scheduleWarning(long timeout) {
        this.currentScheduledFuture = this.scheduledExecutorService.schedule(() -> {
            if (!this.completed) {
                this.scheduleWarningOrInterrupt();
            }
        }, timeout, TimeUnit.MILLISECONDS);
    }

    private void scheduleWarningOrInterrupt() {
        long takenTime = System.currentTimeMillis() - this.startTimeMs;
        this.logger.warn("{} is taking a long time to process. Current time: [{}ms]. Will be interrupted in [{}ms].\nStacktrace of current thread:\n{}", new Object[]{this.taskName, takenTime, (long)this.timeout - takenTime, this.getCurrentStackTrace()});
        if (takenTime + (long)this.warningInterval < (long)this.timeout) {
            this.scheduleWarning(this.warningInterval);
        } else {
            this.scheduleInterrupt((long)this.timeout - takenTime);
        }
    }

    private void scheduleInterrupt(long remainingTimeout) {
        this.currentScheduledFuture = this.scheduledExecutorService.schedule(() -> {
            if (!this.completed) {
                this.logger.error("{} has exceeded its timeout of [{}ms]. Interrupting thread.\nStacktrace of current thread:\n{}", new Object[]{this.taskName, this.timeout, this.getCurrentStackTrace()});
                this.thread.interrupt();
                this.interrupted = true;
            }
        }, remainingTimeout, TimeUnit.MILLISECONDS);
    }

    private String getCurrentStackTrace() {
        StackTraceElement[] stackTrace = this.thread.getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : stackTrace) {
            sb.append(element).append("\n");
            if (element.toString().contains(this.startStackTrace)) break;
        }
        return sb.toString();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }
}

