/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.interceptors;

import jakarta.validation.ConstraintViolation;
import java.lang.invoke.CallSite;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.axonframework.common.AxonNonTransientException;

public class JSR303ViolationException
extends AxonNonTransientException {
    private final Set<ConstraintViolation<Object>> violations;

    public JSR303ViolationException(Set<ConstraintViolation<Object>> violations) {
        super("One or more JSR303 constraints were violated: " + System.lineSeparator() + JSR303ViolationException.convert(violations));
        this.violations = violations;
    }

    public Set<ConstraintViolation<Object>> getViolations() {
        return this.violations;
    }

    protected static String convert(Set<ConstraintViolation<Object>> violations) {
        TreeSet<CallSite> sortedViolations = new TreeSet<CallSite>();
        for (ConstraintViolation<Object> violation : violations) {
            String msg = "property " + String.valueOf(violation.getPropertyPath());
            msg = msg + " in " + String.valueOf(violation.getRootBeanClass());
            msg = msg + " " + violation.getMessage();
            sortedViolations.add((CallSite)((Object)msg));
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = sortedViolations.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }
}

