/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.Executable;
import java.util.Comparator;
import org.axonframework.messaging.annotation.MessageHandlingMember;

public final class HandlerComparator {
    private static final Comparator<MessageHandlingMember<?>> INSTANCE = Comparator.comparingInt(MessageHandlingMember::priority).reversed().thenComparing(m -> !HandlerComparator.isResultHandler(m)).thenComparing((memberOne, memberTwo) -> {
        Comparator<MessageHandlingMember> handlerComparator = Comparator.comparing(MessageHandlingMember::payloadType, HandlerComparator::compareHierarchy).thenComparing(Comparator.comparingInt(HandlerComparator::parameterCount).reversed()).thenComparing(HandlerComparator::executableSignature);
        return HandlerComparator.isResultHandler(memberOne) || HandlerComparator.isResultHandler(memberTwo) ? handlerComparator.reversed().compare((MessageHandlingMember)memberOne, (MessageHandlingMember)memberTwo) : handlerComparator.compare((MessageHandlingMember)memberOne, (MessageHandlingMember)memberTwo);
    });

    private static boolean isResultHandler(MessageHandlingMember<?> m) {
        return m.attribute("ResultHandler.resultType").isPresent();
    }

    private HandlerComparator() {
    }

    public static Comparator<MessageHandlingMember<?>> instance() {
        return INSTANCE;
    }

    private static int compareHierarchy(Class<?> o1, Class<?> o2) {
        if (o1.isInterface() && !o2.isInterface()) {
            return 1;
        }
        if (!o1.isInterface() && o2.isInterface()) {
            return -1;
        }
        return Integer.compare(HandlerComparator.depthOf(o2), HandlerComparator.depthOf(o1));
    }

    private static int depthOf(Class<?> o1) {
        int depth = 0;
        if (o1.isInterface()) {
            while (type.getInterfaces().length > 0) {
                ++depth;
                type = type.getInterfaces()[0];
            }
        } else {
            for (type = o1; type != null; type = type.getSuperclass()) {
                ++depth;
            }
        }
        if (o1.isAnnotation()) {
            depth += 1000;
        }
        return depth;
    }

    private static Integer parameterCount(MessageHandlingMember<?> handler) {
        return handler.unwrap(Executable.class).map(Executable::getParameterCount).orElse(1);
    }

    private static String executableSignature(MessageHandlingMember<?> handler) {
        return handler.unwrap(Executable.class).map(Executable::toGenericString).orElse(handler.toString());
    }
}

