/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Optional;
import org.axonframework.common.Priority;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.annotation.MessageHandler;
import org.axonframework.messaging.annotation.MetaDataValue;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.annotation.PayloadParameterResolver;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Priority(value=-1073741824)
public class DefaultParameterResolverFactory
implements ParameterResolverFactory {
    @Override
    @Nullable
    public ParameterResolver createInstance(@Nonnull Executable executable, @Nonnull Parameter[] parameters, int parameterIndex) {
        Class<Object> payloadType;
        Class<?> parameterType = parameters[parameterIndex].getType();
        if (Message.class.isAssignableFrom(parameterType)) {
            return new MessageParameterResolver(parameterType);
        }
        Optional<Map<String, Object>> metaDataValueAnnotation = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)parameters[parameterIndex], MetaDataValue.class);
        if (metaDataValueAnnotation.isPresent()) {
            return new AnnotatedMetaDataParameterResolver(metaDataValueAnnotation.get(), parameterType);
        }
        if (MetaData.class.isAssignableFrom(parameterType)) {
            return MetaDataParameterResolver.INSTANCE;
        }
        if (parameterIndex == 0 && (payloadType = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)executable, MessageHandler.class).map(attr -> attr.get("payloadType")).orElse(Object.class)).isAssignableFrom(parameterType)) {
            return new PayloadParameterResolver(parameterType);
        }
        return null;
    }

    private static class MessageParameterResolver
    implements ParameterResolver<Message<?>> {
        private final Class<?> parameterType;

        public MessageParameterResolver(Class<?> parameterType) {
            this.parameterType = parameterType;
        }

        @Override
        @Nullable
        public Message<?> resolveParameterValue(@Nonnull ProcessingContext context) {
            return Message.fromContext(context);
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            Message<?> message = Message.fromContext(context);
            if (message == null) {
                return false;
            }
            return this.parameterType.isAssignableFrom(message.getClass());
        }
    }

    private static class AnnotatedMetaDataParameterResolver
    implements ParameterResolver<Object> {
        private static final String REQUIRED_PROPERTY = "required";
        private static final String META_DATA_VALUE_PROPERTY = "metaDataValue";
        private final Map<String, Object> metaDataValue;
        private final Class<?> parameterType;

        public AnnotatedMetaDataParameterResolver(Map<String, Object> metaDataValue, Class<?> parameterType) {
            this.metaDataValue = metaDataValue;
            this.parameterType = parameterType;
        }

        @Override
        public Object resolveParameterValue(@Nonnull ProcessingContext context) {
            return Message.fromContext(context).getMetaData().get(this.metaDataValue.get(META_DATA_VALUE_PROPERTY).toString());
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            Message<?> message = Message.fromContext(context);
            if (message == null) {
                return false;
            }
            return !this.parameterType.isPrimitive() && (Boolean)this.metaDataValue.get(REQUIRED_PROPERTY) == false || message.getMetaData().containsKey(this.metaDataValue.get(META_DATA_VALUE_PROPERTY).toString()) && this.parameterType.isInstance(message.getMetaData().get(this.metaDataValue.get(META_DATA_VALUE_PROPERTY).toString()));
        }
    }

    private static final class MetaDataParameterResolver
    implements ParameterResolver<MetaData> {
        private static final MetaDataParameterResolver INSTANCE = new MetaDataParameterResolver();

        private MetaDataParameterResolver() {
        }

        @Override
        @Nullable
        public MetaData resolveParameterValue(@Nonnull ProcessingContext context) {
            Message<?> message = Message.fromContext(context);
            return message.getMetaData();
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return Message.fromContext(context) != null;
        }
    }
}

