/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.HandlerAttributes;
import org.axonframework.messaging.SimpleHandlerAttributes;
import org.axonframework.messaging.annotation.HasHandlerAttributes;

public class AnnotatedHandlerAttributes
implements HandlerAttributes {
    private final AnnotatedElement annotatedElement;
    private final SimpleHandlerAttributes simpleHandlerAttributes;

    public AnnotatedHandlerAttributes(AnnotatedElement annotatedElement) {
        this.annotatedElement = annotatedElement;
        this.simpleHandlerAttributes = new SimpleHandlerAttributes(AnnotatedHandlerAttributes.constructHandlerAttributesFor(annotatedElement));
    }

    private static Map<String, Object> constructHandlerAttributesFor(AnnotatedElement element) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        HashSet<Class<? extends Annotation>> visitedAnnotations = new HashSet<Class<? extends Annotation>>();
        for (Annotation annotation : element.getAnnotations()) {
            HashSet<Class<? extends Annotation>> annotatedWithHasHandlerAttributes = new HashSet<Class<? extends Annotation>>();
            if (!AnnotationUtils.isAnnotatedWith(annotation.annotationType(), HasHandlerAttributes.class, annotatedWithHasHandlerAttributes, visitedAnnotations)) continue;
            for (Class clazz : annotatedWithHasHandlerAttributes) {
                AnnotationUtils.findAnnotationAttributes(element, clazz, true).ifPresent(annotatedAttributes -> annotatedAttributes.forEach((attributeName, attribute) -> attributes.put(AnnotatedHandlerAttributes.prefixedKey(handlerAnnotation.getSimpleName(), attributeName), attribute)));
            }
        }
        return attributes;
    }

    private static String prefixedKey(String handlerType, String attributeName) {
        return handlerType + "." + attributeName;
    }

    @Override
    public <R> R get(String attributeKey) {
        return this.simpleHandlerAttributes.get(attributeKey);
    }

    @Override
    public Map<String, Object> getAll() {
        return this.simpleHandlerAttributes.getAll();
    }

    @Override
    public boolean contains(String attributeKey) {
        return this.simpleHandlerAttributes.contains(attributeKey);
    }

    @Override
    public boolean isEmpty() {
        return this.simpleHandlerAttributes.isEmpty();
    }

    @Override
    public HandlerAttributes mergedWith(HandlerAttributes other) {
        return this.simpleHandlerAttributes.mergedWith(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotatedHandlerAttributes that = (AnnotatedHandlerAttributes)o;
        return Objects.equals(this.annotatedElement, that.annotatedElement) && Objects.equals(this.simpleHandlerAttributes, that.simpleHandlerAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.annotatedElement, this.simpleHandlerAttributes);
    }

    public String toString() {
        return "AnnotatedHandlerAttributes{annotatedElement=" + String.valueOf(this.annotatedElement) + ", simpleHandlerAttributes=" + String.valueOf(this.simpleHandlerAttributes) + "}";
    }
}

