/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Optional;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.IllegalPayloadAccessException;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDecorator;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public class GenericResultMessage<R>
extends MessageDecorator<R>
implements ResultMessage<R> {
    private final Throwable exception;

    public GenericResultMessage(@Nonnull MessageType type, @Nullable R result) {
        this(type, result, (Map<String, String>)MetaData.emptyInstance());
    }

    public GenericResultMessage(@Nonnull MessageType type, @Nonnull Throwable exception) {
        this(type, exception, (Map<String, String>)MetaData.emptyInstance());
    }

    public GenericResultMessage(@Nonnull MessageType type, @Nullable R result, @Nonnull Map<String, String> metaData) {
        this((Message<R>)new GenericMessage<R>(type, result, metaData));
    }

    public GenericResultMessage(@Nonnull MessageType type, @Nonnull Throwable exception, @Nonnull Map<String, String> metaData) {
        this(new GenericMessage<Object>(type, null, metaData), exception);
    }

    public GenericResultMessage(@Nonnull Message<R> delegate) {
        this(delegate, GenericResultMessage.findExceptionResult(delegate));
    }

    public GenericResultMessage(@Nonnull Message<R> delegate, @Nonnull Throwable exception) {
        super(delegate);
        this.exception = exception;
    }

    @Deprecated
    public static <R> ResultMessage<R> asResultMessage(Object result) {
        if (result instanceof ResultMessage) {
            return (ResultMessage)result;
        }
        if (result instanceof Message) {
            Message resultMessage = (Message)result;
            return new GenericResultMessage<R>(resultMessage);
        }
        MessageType type = result == null ? new MessageType("empty.result") : new MessageType(result.getClass());
        return new GenericResultMessage<Object>(type, result);
    }

    @Deprecated
    public static <R> ResultMessage<R> asResultMessage(Throwable exception) {
        return new GenericResultMessage<R>(new MessageType(exception.getClass()), exception);
    }

    private static <R> Throwable findExceptionResult(Message<R> delegate) {
        if (delegate instanceof ResultMessage && ((ResultMessage)delegate).isExceptional()) {
            return ((ResultMessage)delegate).exceptionResult();
        }
        return null;
    }

    @Override
    public boolean isExceptional() {
        return this.exception != null;
    }

    @Override
    public Optional<Throwable> optionalExceptionResult() {
        return Optional.ofNullable(this.exception);
    }

    @Override
    public <S> SerializedObject<S> serializePayload(Serializer serializer, Class<S> expectedRepresentation) {
        if (this.isExceptional()) {
            return serializer.serialize(this.exceptionDetails().orElse(null), expectedRepresentation);
        }
        return super.serializePayload(serializer, expectedRepresentation);
    }

    @Override
    public GenericResultMessage<R> withMetaData(@Nonnull Map<String, String> metaData) {
        return new GenericResultMessage(this.getDelegate().withMetaData(metaData), this.exception);
    }

    @Override
    public GenericResultMessage<R> andMetaData(@Nonnull Map<String, String> metaData) {
        return new GenericResultMessage(this.getDelegate().andMetaData(metaData), this.exception);
    }

    @Override
    protected void describeTo(StringBuilder stringBuilder) {
        stringBuilder.append("payload={").append((Object)(this.isExceptional() ? null : this.getPayload())).append('}').append(", metadata={").append(this.getMetaData()).append('}').append(", messageIdentifier='").append(this.getIdentifier()).append('\'').append(", exception='").append(this.exception).append('\'');
    }

    @Override
    protected String describeType() {
        return "GenericResultMessage";
    }

    @Override
    public R getPayload() {
        if (this.isExceptional()) {
            throw new IllegalPayloadAccessException("This result completed exceptionally, payload is not available. Try calling 'exceptionResult' to see the cause of failure.", this.exception);
        }
        return (R)super.getPayload();
    }
}

