/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.ReplayToken;
import org.axonframework.eventhandling.Segment;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class MultiEventHandlerInvoker
implements EventHandlerInvoker {
    private final List<EventHandlerInvoker> delegates;

    public MultiEventHandlerInvoker(EventHandlerInvoker ... delegates) {
        this(Arrays.asList(delegates));
    }

    public MultiEventHandlerInvoker(@Nonnull List<EventHandlerInvoker> delegates) {
        this.delegates = this.flatten(delegates);
    }

    private List<EventHandlerInvoker> flatten(List<EventHandlerInvoker> invokers) {
        ArrayList<EventHandlerInvoker> flattened = new ArrayList<EventHandlerInvoker>();
        for (EventHandlerInvoker invoker : invokers) {
            if (invoker instanceof MultiEventHandlerInvoker) {
                flattened.addAll(((MultiEventHandlerInvoker)invoker).delegates());
                continue;
            }
            flattened.add(invoker);
        }
        return flattened;
    }

    @Nonnull
    public List<EventHandlerInvoker> delegates() {
        return Collections.unmodifiableList(this.delegates);
    }

    @Override
    public boolean canHandle(@Nonnull EventMessage<?> eventMessage, @Nonnull ProcessingContext context, @Nonnull Segment segment) {
        return this.delegates.stream().anyMatch(i -> this.canHandle((EventHandlerInvoker)i, eventMessage, context, segment));
    }

    private boolean canHandle(EventHandlerInvoker invoker, EventMessage<?> eventMessage, ProcessingContext context, Segment segment) {
        return (invoker.supportsReset() || !ReplayToken.isReplay(eventMessage)) && invoker.canHandle(eventMessage, context, segment);
    }

    @Override
    public boolean canHandleType(@Nonnull Class<?> payloadType) {
        return this.delegates.stream().anyMatch(i -> i.canHandleType(payloadType));
    }

    @Override
    public void handle(@Nonnull EventMessage<?> message, @Nonnull ProcessingContext context, @Nonnull Segment segment) throws Exception {
        for (EventHandlerInvoker i : this.delegates) {
            if (!this.canHandle(i, message, context, segment)) continue;
            i.handle(message, context, segment);
        }
    }

    @Override
    public boolean supportsReset() {
        return this.delegates.stream().anyMatch(EventHandlerInvoker::supportsReset);
    }

    @Override
    public void performReset(ProcessingContext context) {
        this.performReset(null, context);
    }

    @Override
    public <R> void performReset(R resetContext, ProcessingContext processingContext) {
        this.delegates.stream().filter(EventHandlerInvoker::supportsReset).forEach(eventHandlerInvoker -> eventHandlerInvoker.performReset(resetContext, processingContext));
    }
}

