/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.jobrunr;

import jakarta.annotation.Nonnull;
import org.axonframework.common.digest.Digester;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.serialization.Serializer;

public abstract class LabelUtils {
    private static final int MAX_LENGTH = 44;

    private LabelUtils() {
    }

    public static String getLabel(String input) {
        if (input.length() <= 44) {
            return input;
        }
        return Digester.md5Hex(input);
    }

    private static String getScopeLabel(@Nonnull Serializer serializer, @Nonnull ScopeDescriptor scope) {
        return LabelUtils.getLabel(serializer.serialize(scope, String.class).getData());
    }

    public static String getCombinedLabel(@Nonnull Serializer serializer, @Nonnull String deadlineName, @Nonnull ScopeDescriptor scope) {
        String scopeLabel = LabelUtils.getScopeLabel(serializer, scope);
        return LabelUtils.getLabel(deadlineName + scopeLabel);
    }
}

