/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Consumer;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.configuration.ApplicationConfigurer;
import org.axonframework.configuration.AxonConfiguration;
import org.axonframework.configuration.ComponentBuilder;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.DefaultAxonApplication;
import org.axonframework.configuration.LifecycleRegistry;
import org.axonframework.configuration.MessagingConfigurationDefaults;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.configuration.reflection.ParameterResolverFactoryUtils;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryUpdateEmitter;

public class MessagingConfigurer
implements ApplicationConfigurer {
    private final ApplicationConfigurer applicationConfigurer;

    private MessagingConfigurer(@Nonnull ApplicationConfigurer applicationConfigurer) {
        this.applicationConfigurer = Objects.requireNonNull(applicationConfigurer, "The Application Configurer cannot be null.");
    }

    public static MessagingConfigurer enhance(@Nonnull ApplicationConfigurer applicationConfigurer) {
        return new MessagingConfigurer(applicationConfigurer).componentRegistry(cr -> cr.registerEnhancer(new MessagingConfigurationDefaults()));
    }

    public static MessagingConfigurer create() {
        return MessagingConfigurer.enhance(new DefaultAxonApplication());
    }

    public MessagingConfigurer registerMessageTypeResolver(@Nonnull ComponentBuilder<MessageTypeResolver> messageTypeResolverFactory) {
        this.applicationConfigurer.componentRegistry((ComponentRegistry cr) -> cr.registerComponent(MessageTypeResolver.class, messageTypeResolverFactory));
        return this;
    }

    public MessagingConfigurer registerCommandBus(@Nonnull ComponentBuilder<CommandBus> commandBusBuilder) {
        this.applicationConfigurer.componentRegistry((ComponentRegistry cr) -> cr.registerComponent(CommandBus.class, commandBusBuilder));
        return this;
    }

    public MessagingConfigurer registerEventSink(@Nonnull ComponentBuilder<EventSink> eventSinkBuilder) {
        this.applicationConfigurer.componentRegistry((ComponentRegistry cr) -> cr.registerComponent(EventSink.class, eventSinkBuilder));
        return this;
    }

    public MessagingConfigurer registerQueryBus(@Nonnull ComponentBuilder<QueryBus> queryBusBuilder) {
        this.applicationConfigurer.componentRegistry((ComponentRegistry cr) -> cr.registerComponent(QueryBus.class, queryBusBuilder));
        return this;
    }

    public MessagingConfigurer registerParameterResolverFactory(@Nonnull ComponentBuilder<ParameterResolverFactory> parameterResolverFactoryBuilder) {
        this.applicationConfigurer.componentRegistry((ComponentRegistry registry) -> ParameterResolverFactoryUtils.registerToComponentRegistry(registry, parameterResolverFactoryBuilder::build));
        return this;
    }

    public MessagingConfigurer registerQueryUpdateEmitter(@Nonnull ComponentBuilder<QueryUpdateEmitter> queryUpdateEmitterBuilder) {
        this.applicationConfigurer.componentRegistry((ComponentRegistry cr) -> cr.registerComponent(QueryUpdateEmitter.class, queryUpdateEmitterBuilder));
        return this;
    }

    @Override
    public MessagingConfigurer componentRegistry(@Nonnull Consumer<ComponentRegistry> componentRegistrar) {
        this.applicationConfigurer.componentRegistry(Objects.requireNonNull(componentRegistrar, "The configure task must no be null."));
        return this;
    }

    @Override
    public MessagingConfigurer lifecycleRegistry(@Nonnull Consumer<LifecycleRegistry> lifecycleRegistrar) {
        this.applicationConfigurer.lifecycleRegistry(Objects.requireNonNull(lifecycleRegistrar, "The lifecycle registrar must not be null."));
        return this;
    }

    @Override
    public AxonConfiguration build() {
        return this.applicationConfigurer.build();
    }
}

