/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.axonframework.common.Assert;
import org.axonframework.configuration.Component;
import org.axonframework.configuration.ComponentDecorator;
import org.axonframework.configuration.ComponentLifecycleHandler;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.DefaultDecoratorDefinition;

public sealed interface DecoratorDefinition<C, D extends C> {
    public static <C> PartialDecoratorDefinition<C> forType(final @Nonnull Class<C> type) {
        Objects.requireNonNull(type, "The type must not be null.");
        return new PartialDecoratorDefinition<C>(){

            @Override
            public <D extends C> DecoratorDefinition<C, D> with(@Nonnull ComponentDecorator<C, D> decorator) {
                return new DefaultDecoratorDefinition(id -> type.isAssignableFrom(id.typeAsClass()), decorator);
            }
        };
    }

    public static <C> PartialDecoratorDefinition<C> forTypeAndName(final @Nonnull Class<C> type, final @Nonnull String name) {
        Objects.requireNonNull(type, "The type must not be null.");
        Assert.nonEmpty(name, "The name must not be empty or null.");
        return new PartialDecoratorDefinition<C>(){

            @Override
            public <D extends C> DecoratorDefinition<C, D> with(@Nonnull ComponentDecorator<C, D> decorator) {
                return new DefaultDecoratorDefinition(id -> type.isAssignableFrom(id.typeAsClass()) && Objects.equals(name, id.name()), decorator);
            }
        };
    }

    public DecoratorDefinition<C, D> order(int var1);

    public DecoratorDefinition<C, D> onStart(int var1, @Nonnull ComponentLifecycleHandler<D> var2);

    default public DecoratorDefinition<C, D> onStart(int phase, @Nonnull Consumer<D> handler) {
        return this.onStart(phase, (Configuration config, D component) -> {
            Objects.requireNonNull(handler, "The start handler cannot be null.").accept(component);
            return CompletableFuture.completedFuture(null);
        });
    }

    public DecoratorDefinition<C, D> onShutdown(int var1, @Nonnull ComponentLifecycleHandler<D> var2);

    default public DecoratorDefinition<C, D> onShutdown(int phase, @Nonnull Consumer<D> handler) {
        return this.onShutdown(phase, (Configuration config, D component) -> {
            Objects.requireNonNull(handler, "The shutdown handler cannot be null.").accept(component);
            return CompletableFuture.completedFuture(null);
        });
    }

    public static interface CompletedDecoratorDefinition<C, D extends C>
    extends DecoratorDefinition<C, D> {
        public int order();

        public Component<C> decorate(@Nonnull Component<C> var1);

        public boolean matches(@Nonnull Component.Identifier<?> var1);
    }

    public static interface PartialDecoratorDefinition<C> {
        public <D extends C> DecoratorDefinition<C, D> with(@Nonnull ComponentDecorator<C, D> var1);
    }
}

