/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.distributed.Connector;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.serialization.PayloadConverter;

public class PayloadConvertingConnector<T>
implements Connector {
    private final Connector delegate;
    private final PayloadConverter converter;
    private final Type representation;

    public PayloadConvertingConnector(Connector delegate, PayloadConverter converter, Class<T> representation) {
        this(delegate, converter, (Type)representation);
    }

    public PayloadConvertingConnector(Connector delegate, PayloadConverter converter, Type representation) {
        this.delegate = delegate;
        this.converter = converter;
        this.representation = representation;
    }

    @Override
    public CompletableFuture<CommandResultMessage<?>> dispatch(CommandMessage<?> command, ProcessingContext processingContext) {
        CommandMessage serializedCommand = (CommandMessage)this.converter.convertPayload(command, this.representation);
        return this.delegate.dispatch(serializedCommand, processingContext);
    }

    @Override
    public void subscribe(String commandName, int loadFactor) {
        this.delegate.subscribe(commandName, loadFactor);
    }

    @Override
    public boolean unsubscribe(String commandName) {
        return this.delegate.unsubscribe(commandName);
    }

    @Override
    public void onIncomingCommand(BiConsumer<CommandMessage<?>, Connector.ResultCallback> handler) {
        this.delegate.onIncomingCommand((commandMessage, callback) -> handler.accept((CommandMessage<?>)commandMessage, new SerializingResultCallback((Connector.ResultCallback)callback)));
    }

    private class SerializingResultCallback
    implements Connector.ResultCallback {
        private final Connector.ResultCallback callback;

        public SerializingResultCallback(Connector.ResultCallback callback) {
            this.callback = callback;
        }

        @Override
        public void success(Message<?> resultMessage) {
            this.callback.success((Message<?>)PayloadConvertingConnector.this.converter.convertPayload(resultMessage, PayloadConvertingConnector.this.representation));
        }

        @Override
        public void error(Throwable cause) {
            this.callback.error(cause);
        }
    }
}

