/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates;

import jakarta.annotation.Nonnull;
import org.axonframework.common.annotation.Internal;
import org.axonframework.configuration.ComponentDefinition;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.updates.LoggingUpdateCheckerReporter;
import org.axonframework.updates.UpdateChecker;
import org.axonframework.updates.UpdateCheckerHttpClient;
import org.axonframework.updates.UpdateCheckerReporter;
import org.axonframework.updates.configuration.UsagePropertyProvider;
import org.axonframework.updates.detection.TestEnvironmentDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class UpdateCheckerConfigurationEnhancer
implements ConfigurationEnhancer {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCheckerConfigurationEnhancer.class);

    @Override
    public void enhance(@Nonnull ComponentRegistry componentRegistry) {
        if (TestEnvironmentDetector.isTestEnvironment()) {
            logger.debug("Skipping AxonIQ UpdateChecker as a testsuite environment was detected.");
            return;
        }
        componentRegistry.registerIfNotPresent(ComponentDefinition.ofType(UsagePropertyProvider.class).withBuilder(c -> UsagePropertyProvider.create())).registerIfNotPresent(ComponentDefinition.ofType(UpdateCheckerHttpClient.class).withBuilder(c -> {
            UsagePropertyProvider propertyProvider = c.getComponent(UsagePropertyProvider.class);
            return new UpdateCheckerHttpClient(propertyProvider);
        })).registerIfNotPresent(ComponentDefinition.ofType(UpdateCheckerReporter.class).withBuilder(c -> new LoggingUpdateCheckerReporter())).registerIfNotPresent(ComponentDefinition.ofType(UpdateChecker.class).withBuilder(c -> new UpdateChecker(c.getComponent(UpdateCheckerHttpClient.class), c.getComponent(UpdateCheckerReporter.class))).onStart(-134217728, UpdateChecker::start).onShutdown(-134217728, UpdateChecker::stop));
    }

    @Override
    public int order() {
        return Integer.MAX_VALUE;
    }
}

