/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.axonframework.serialization.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JacksonConverter
implements Converter {
    private static final Logger logger = LoggerFactory.getLogger(JacksonConverter.class);
    private final ObjectMapper objectMapper;

    public JacksonConverter() {
        this(new ObjectMapper().findAndRegisterModules());
    }

    public JacksonConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean canConvert(@Nonnull Class<?> sourceType, @Nonnull Class<?> targetType) {
        return sourceType.equals(targetType) || JacksonConverter.canSerialize(targetType) || JacksonConverter.canDeserialize(sourceType);
    }

    private static boolean canSerialize(Class<?> targetType) {
        return byte[].class.isAssignableFrom(targetType) || String.class.isAssignableFrom(targetType);
    }

    private static boolean canDeserialize(Class<?> sourceType) {
        return byte[].class.isAssignableFrom(sourceType) || String.class.isAssignableFrom(sourceType);
    }

    @Override
    @Nullable
    public <S, T> T convert(@Nullable S input, @Nonnull Class<S> sourceType, @Nonnull Class<T> targetType) {
        if (input == null) {
            return null;
        }
        if (sourceType.equals(targetType)) {
            return targetType.cast(input);
        }
        try {
            return this.performConversion(input, sourceType, targetType);
        }
        catch (JsonProcessingException e) {
            String errorMessage = "Failed to convert between %s and %s: %s\n".formatted(sourceType.getSimpleName(), targetType.getSimpleName(), e.getMessage());
            logger.error(errorMessage, (Throwable)e);
            throw new ConversionException(errorMessage, e);
        }
    }

    private <S, T> T performConversion(S input, Class<S> sourceType, Class<T> targetType) throws JsonProcessingException {
        if (JacksonConverter.canSerialize(targetType)) {
            String json = this.objectMapper.writeValueAsString(input);
            return (T)(switch (targetType.getName()) {
                case "[B" -> json.getBytes(StandardCharsets.UTF_8);
                case "java.lang.String" -> json;
                default -> throw new IllegalArgumentException("Unsupported target type: " + String.valueOf(targetType));
            });
        }
        S s = input;
        Objects.requireNonNull(s);
        S s2 = s;
        int n = 0;
        String jsonInput = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{byte[].class, String.class}, s2, n)) {
            case 0 -> {
                byte[] bytes = (byte[])s2;
                yield new String(bytes, StandardCharsets.UTF_8);
            }
            case 1 -> {
                String str;
                yield str = (String)s2;
            }
            default -> throw new IllegalArgumentException("Unsupported source type: " + String.valueOf(sourceType));
        };
        return (T)this.objectMapper.readValue(jsonInput, targetType);
    }

    public static final class ConversionException
    extends RuntimeException {
        public ConversionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

