/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.registration;

import java.lang.reflect.Type;
import java.util.List;
import org.axonframework.queryhandling.QuerySubscription;
import org.axonframework.queryhandling.registration.DuplicateQueryHandlerResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingDuplicateQueryHandlerResolver
implements DuplicateQueryHandlerResolver {
    private static final Logger logger = LoggerFactory.getLogger(LoggingDuplicateQueryHandlerResolver.class);
    private static final LoggingDuplicateQueryHandlerResolver INSTANCE = new LoggingDuplicateQueryHandlerResolver();

    public static LoggingDuplicateQueryHandlerResolver instance() {
        return INSTANCE;
    }

    private LoggingDuplicateQueryHandlerResolver() {
    }

    @Override
    public List<QuerySubscription<?>> resolve(String queryName, Type responseType, List<QuerySubscription<?>> registeredHandlers, QuerySubscription<?> candidateHandler) {
        logger.warn("A duplicate query handler was found for query [{}] and response type [{}]. It has also been registered to the query bus. This is only valid for ScatterGather queries. Normal queries will only use one of these handlers.", (Object)queryName, (Object)responseType.getTypeName());
        registeredHandlers.add(candidateHandler);
        return registeredHandlers;
    }
}

