/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.InterceptorChainParameterResolverFactory;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.MessageInterceptingMember;
import org.axonframework.messaging.annotation.ResultParameterResolverFactory;
import org.axonframework.messaging.annotation.WrappedMessageHandlingMember;
import org.axonframework.messaging.interceptors.MessageHandlerInterceptor;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class MessageHandlerInterceptorDefinition
implements HandlerEnhancerDefinition {
    @Override
    @Nonnull
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        String messageHandlerInterceptorMessageTypeAttributeKey = MessageHandlerInterceptor.class.getSimpleName() + ".messageType";
        if (original.attribute(messageHandlerInterceptorMessageTypeAttributeKey).isPresent()) {
            Optional resultType = original.attribute("ResultHandler.resultType");
            return resultType.isPresent() ? new ResultHandlingInterceptorMember<T>(original, (Class)resultType.get()) : new InterceptedMessageHandlingMember<T>(original);
        }
        return original;
    }

    private static class ResultHandlingInterceptorMember<T>
    extends WrappedMessageHandlingMember<T>
    implements MessageInterceptingMember<T> {
        private final Class<?> expectedResultType;

        public ResultHandlingInterceptorMember(MessageHandlingMember<T> original, Class<?> expectedResultType) {
            super(original);
            this.expectedResultType = expectedResultType;
            Method method = original.unwrap(Method.class).orElseThrow(() -> new AxonConfigurationException("Only methods can be marked as MessageHandlerInterceptor. Violating handler: " + original.signature()));
            boolean declaredInterceptorChain = Arrays.stream(method.getParameters()).anyMatch(p -> p.getType().equals(InterceptorChain.class));
            if (declaredInterceptorChain) {
                throw new AxonConfigurationException("A MessageHandlerInterceptor acting on the invocation result must not declare a parameter of type InterceptorChain. Violating handler: " + original.signature());
            }
        }

        @Override
        public int priority() {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean canHandle(@Nonnull Message<?> message, @Nonnull ProcessingContext context) {
            return ResultParameterResolverFactory.ignoringResultParameters(context, pc -> super.canHandle(message, (ProcessingContext)pc));
        }

        @Override
        public Object handleSync(@Nonnull Message<?> message, @Nonnull ProcessingContext context, @Nullable T target) throws Exception {
            InterceptorChain chain = InterceptorChainParameterResolverFactory.currentInterceptorChain();
            try {
                return chain.proceedSync(context);
            }
            catch (Exception e) {
                if (!this.expectedResultType.isInstance(e)) {
                    throw e;
                }
                return ResultParameterResolverFactory.callWithResult(e, () -> {
                    if (super.canHandle(message, context)) {
                        return super.handleSync(message, context, target);
                    }
                    throw e;
                });
            }
        }

        @Override
        public MessageStream<?> handle(@Nonnull Message<?> message, @Nonnull ProcessingContext context, @Nullable T target) {
            InterceptorChain chain = InterceptorChainParameterResolverFactory.currentInterceptorChain(context);
            return chain.proceed(message, context).map(r -> r).onErrorContinue(error -> {
                if (this.expectedResultType.isInstance(error)) {
                    return MessageStream.failed(error);
                }
                return ResultParameterResolverFactory.callWithResult(error, context, pc -> {
                    if (super.canHandle(message, (ProcessingContext)pc)) {
                        return super.handle(message, (ProcessingContext)pc, target).map(r -> r);
                    }
                    return MessageStream.failed(error);
                });
            });
        }
    }

    private static class InterceptedMessageHandlingMember<T>
    extends WrappedMessageHandlingMember<T>
    implements MessageInterceptingMember<T> {
        private final boolean shouldInvokeInterceptorChain;

        public InterceptedMessageHandlingMember(MessageHandlingMember<T> original) {
            super(original);
            Method method = original.unwrap(Method.class).orElseThrow(() -> new AxonConfigurationException("Only methods can be marked as MessageHandlerInterceptor. Violating handler: " + original.signature()));
            this.shouldInvokeInterceptorChain = Arrays.stream(method.getParameters()).noneMatch(p -> p.getType().equals(InterceptorChain.class));
            if (this.shouldInvokeInterceptorChain && !Void.TYPE.equals(method.getReturnType())) {
                throw new AxonConfigurationException("A MessageHandlerInterceptor must either return null or declare a parameter of type InterceptorChain. Violating handler: " + original.signature());
            }
        }

        @Override
        public Object handleSync(@Nonnull Message<?> message, @Nonnull ProcessingContext context, @Nullable T target) throws Exception {
            Object result = super.handleSync(message, context, target);
            if (this.shouldInvokeInterceptorChain) {
                return InterceptorChainParameterResolverFactory.currentInterceptorChain().proceedSync(context);
            }
            return result;
        }
    }
}

