/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public abstract class MessageDecorator<P>
implements Message<P> {
    private final Message<P> delegate;

    protected MessageDecorator(@Nonnull Message<P> delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getIdentifier() {
        return this.delegate.getIdentifier();
    }

    @Override
    @Nonnull
    public MessageType type() {
        return this.delegate.type();
    }

    @Override
    public MetaData getMetaData() {
        return this.delegate.getMetaData();
    }

    @Override
    public P getPayload() {
        return this.delegate.getPayload();
    }

    @Override
    public Class<P> getPayloadType() {
        return this.delegate.getPayloadType();
    }

    @Override
    public <S> SerializedObject<S> serializePayload(Serializer serializer, Class<S> expectedRepresentation) {
        return this.delegate.serializePayload(serializer, expectedRepresentation);
    }

    @Override
    public <S> SerializedObject<S> serializeMetaData(Serializer serializer, Class<S> expectedRepresentation) {
        return this.delegate.serializeMetaData(serializer, expectedRepresentation);
    }

    protected Message<P> getDelegate() {
        return this.delegate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.describeType()).append("{");
        this.describeTo(sb);
        return sb.append("}").toString();
    }

    protected void describeTo(StringBuilder stringBuilder) {
        stringBuilder.append("type={").append(this.type()).append('}').append(", payload={").append(this.getPayload()).append('}').append(", metadata={").append(this.getMetaData()).append('}').append(", messageIdentifier='").append(this.getIdentifier()).append('\'');
    }

    protected String describeType() {
        return this.getClass().getSimpleName();
    }
}

