/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.axonframework.common.FutureUtils;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import reactor.core.publisher.Flux;

class EmptyMessageStream
implements MessageStream.Empty<Message<Void>> {
    private static final EmptyMessageStream INSTANCE = new EmptyMessageStream();

    private EmptyMessageStream() {
    }

    public static MessageStream.Empty<Message<Void>> instance() {
        return INSTANCE;
    }

    @Override
    public CompletableFuture<MessageStream.Entry<Message<Void>>> asCompletableFuture() {
        return FutureUtils.emptyCompletedFuture();
    }

    @Override
    public Flux<MessageStream.Entry<Message<Void>>> asFlux() {
        return Flux.empty();
    }

    @Override
    public Optional<MessageStream.Entry<Message<Void>>> next() {
        return Optional.empty();
    }

    @Override
    public void onAvailable(@Nonnull Runnable callback) {
        callback.run();
    }

    @Override
    public Optional<Throwable> error() {
        return Optional.empty();
    }

    @Override
    public boolean isCompleted() {
        return true;
    }

    @Override
    public boolean hasNextAvailable() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public <R> CompletableFuture<R> reduce(@Nonnull R identity, @Nonnull BiFunction<R, MessageStream.Entry<Message<Void>>, R> accumulator) {
        return CompletableFuture.completedFuture(identity);
    }

    @Override
    public MessageStream<Message<Void>> onErrorContinue(@Nonnull Function<Throwable, MessageStream<Message<Void>>> onError) {
        return this;
    }

    @Override
    public MessageStream.Empty<Message<Void>> whenComplete(@Nonnull Runnable completeHandler) {
        try {
            completeHandler.run();
            return this;
        }
        catch (Exception e) {
            return MessageStream.failed(e);
        }
    }

    @Override
    public Optional<MessageStream.Entry<Message<Void>>> peek() {
        return Optional.empty();
    }
}

