/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstreaming;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import org.axonframework.eventstreaming.EventCriteria;
import org.axonframework.eventstreaming.EventTypeRestrictableEventCriteria;
import org.axonframework.eventstreaming.EventTypeRestrictableOrEventCriteria;
import org.axonframework.eventstreaming.Tag;
import org.axonframework.eventstreaming.TagFilteredEventCriteria;

public final class OrEventCriteriaBuilder {
    private final EventCriteria orCriteria;

    OrEventCriteriaBuilder(@Nonnull EventCriteria orCriteria) {
        this.orCriteria = Objects.requireNonNull(orCriteria, "orCriteria may not be null");
    }

    public EventTypeRestrictableEventCriteria havingTags(@Nonnull Set<Tag> tags) {
        return this.wrap(EventCriteria.havingTags(tags));
    }

    public EventTypeRestrictableEventCriteria havingTags(Tag ... tags) {
        return this.wrap(EventCriteria.havingTags(tags));
    }

    public EventTypeRestrictableEventCriteria havingTags(String ... tags) {
        return this.wrap(EventCriteria.havingTags(tags));
    }

    public EventTypeRestrictableEventCriteria havingAnyTag() {
        TagFilteredEventCriteria filteredEventCriteria = new TagFilteredEventCriteria(Set.of());
        return this.wrap(filteredEventCriteria);
    }

    private EventTypeRestrictableEventCriteria wrap(EventTypeRestrictableEventCriteria criteria) {
        return new EventTypeRestrictableOrEventCriteria(criteria, this.orCriteria);
    }
}

