/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.gateway;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.eventhandling.gateway.EventGateway;
import org.axonframework.eventhandling.gateway.EventPublishingUtils;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class DefaultEventGateway
implements EventGateway {
    private final EventSink eventSink;
    private final MessageTypeResolver messageTypeResolver;

    public DefaultEventGateway(@Nonnull EventSink eventSink, @Nonnull MessageTypeResolver messageTypeResolver) {
        this.eventSink = Objects.requireNonNull(eventSink, "EventSink may not be null");
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "MessageTypeResolver may not be null");
    }

    @Override
    public CompletableFuture<Void> publish(@Nullable ProcessingContext context, @Nonnull List<?> events) {
        List<EventMessage<?>> eventMessages = events.stream().map(event -> EventPublishingUtils.asEventMessage(event, this.messageTypeResolver)).collect(Collectors.toList());
        return this.eventSink.publish(context, eventMessages);
    }
}

