/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.WrappedToken;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class TrackingTokenParameterResolverFactory
implements ParameterResolverFactory {
    private static final TrackingTokenParameterResolver RESOLVER = new TrackingTokenParameterResolver();

    @Override
    @Nullable
    public ParameterResolver createInstance(@Nonnull Executable executable, @Nonnull Parameter[] parameters, int parameterIndex) {
        if (TrackingToken.class.equals(parameters[parameterIndex].getType())) {
            return RESOLVER;
        }
        return null;
    }

    private static class TrackingTokenParameterResolver
    implements ParameterResolver<TrackingToken> {
        private TrackingTokenParameterResolver() {
        }

        @Override
        @Nullable
        public TrackingToken resolveParameterValue(@Nonnull ProcessingContext context) {
            Message<?> message = Message.fromContext(context);
            if (message instanceof TrackedEventMessage) {
                TrackedEventMessage trackedEventMessage = (TrackedEventMessage)message;
                return this.unwrap(trackedEventMessage.trackingToken());
            }
            return null;
        }

        private TrackingToken unwrap(TrackingToken trackingToken) {
            return WrappedToken.unwrapLowerBound(trackingToken);
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return Message.fromContext(context) instanceof TrackedEventMessage;
        }
    }
}

