/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.annotation.Nonnull;
import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDecorator;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.CachingSupplier;

public class GenericEventMessage<P>
extends MessageDecorator<P>
implements EventMessage<P> {
    private final Supplier<Instant> timestampSupplier;
    @Deprecated
    public static Clock clock = Clock.systemUTC();

    public GenericEventMessage(@Nonnull MessageType type, @Nonnull P payload) {
        this(type, payload, MetaData.emptyInstance());
    }

    public GenericEventMessage(@Nonnull MessageType type, @Nonnull P payload, @Nonnull Map<String, String> metaData) {
        this(new GenericMessage<P>(type, payload, metaData), clock.instant());
    }

    public GenericEventMessage(@Nonnull String identifier, @Nonnull MessageType type, @Nonnull P payload, @Nonnull Map<String, String> metaData, @Nonnull Instant timestamp) {
        this(new GenericMessage<P>(identifier, type, payload, metaData), timestamp);
    }

    public GenericEventMessage(@Nonnull Message<P> delegate, @Nonnull Supplier<Instant> timestampSupplier) {
        super(delegate);
        this.timestampSupplier = CachingSupplier.of(timestampSupplier);
    }

    protected GenericEventMessage(@Nonnull Message<P> delegate, @Nonnull Instant timestamp) {
        this(delegate, CachingSupplier.of(timestamp));
    }

    @Override
    @Nonnull
    public Instant getTimestamp() {
        return this.timestampSupplier.get();
    }

    @Override
    public GenericEventMessage<P> withMetaData(@Nonnull Map<String, String> metaData) {
        if (this.getMetaData().equals(metaData)) {
            return this;
        }
        return new GenericEventMessage(this.getDelegate().withMetaData(metaData), this.timestampSupplier);
    }

    @Override
    public GenericEventMessage<P> andMetaData(@Nonnull Map<String, String> metaData) {
        if (metaData == null || metaData.isEmpty() || this.getMetaData().equals(metaData)) {
            return this;
        }
        return new GenericEventMessage(this.getDelegate().andMetaData(metaData), this.timestampSupplier);
    }

    @Override
    protected void describeTo(StringBuilder stringBuilder) {
        super.describeTo(stringBuilder);
        stringBuilder.append(", timestamp='").append(this.getTimestamp());
    }

    @Override
    protected String describeType() {
        return "GenericEventMessage";
    }

    @Override
    public <C> EventMessage<C> withConvertedPayload(@Nonnull Function<P, C> conversion) {
        Object payload = this.getPayload();
        C converted = conversion.apply(payload);
        if (Objects.equals(converted, payload)) {
            return this;
        }
        return new GenericEventMessage<C>(this.getIdentifier(), this.type(), converted, this.getMetaData(), this.getTimestamp());
    }
}

