/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.DefaultEventProcessorSpanFactory;
import org.axonframework.eventhandling.ErrorHandler;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventProcessorSpanFactory;
import org.axonframework.eventhandling.PropagatingErrorHandler;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.axonframework.tracing.NoOpSpanFactory;

public abstract class EventProcessorBuilder {
    protected String name;
    protected EventHandlerInvoker eventHandlerInvoker;
    protected ErrorHandler errorHandler = PropagatingErrorHandler.INSTANCE;
    protected MessageMonitor<? super EventMessage<?>> messageMonitor = NoOpMessageMonitor.INSTANCE;
    protected EventProcessorSpanFactory spanFactory = DefaultEventProcessorSpanFactory.builder().spanFactory(NoOpSpanFactory.INSTANCE).build();

    public EventProcessorBuilder name(@Nonnull String name) {
        this.assertEventProcessorName(name, "The EventProcessor name may not be null or empty");
        this.name = name;
        return this;
    }

    public EventProcessorBuilder eventHandlerInvoker(@Nonnull EventHandlerInvoker eventHandlerInvoker) {
        BuilderUtils.assertNonNull(eventHandlerInvoker, "EventHandlerInvoker may not be null");
        this.eventHandlerInvoker = eventHandlerInvoker;
        return this;
    }

    public EventProcessorBuilder errorHandler(@Nonnull ErrorHandler errorHandler) {
        BuilderUtils.assertNonNull(errorHandler, "ErrorHandler may not be null");
        this.errorHandler = errorHandler;
        return this;
    }

    public EventProcessorBuilder messageMonitor(@Nonnull MessageMonitor<? super EventMessage<?>> messageMonitor) {
        BuilderUtils.assertNonNull(messageMonitor, "MessageMonitor may not be null");
        this.messageMonitor = messageMonitor;
        return this;
    }

    public EventProcessorBuilder spanFactory(@Nonnull EventProcessorSpanFactory spanFactory) {
        BuilderUtils.assertNonNull(spanFactory, "SpanFactory may not be null");
        this.spanFactory = spanFactory;
        return this;
    }

    protected void validate() throws AxonConfigurationException {
        this.assertEventProcessorName(this.name, "The EventProcessor name is a hard requirement and should be provided");
        BuilderUtils.assertNonNull(this.eventHandlerInvoker, "The EventHandlerInvoker is a hard requirement and should be provided");
    }

    private void assertEventProcessorName(String eventProcessorName, String exceptionMessage) {
        BuilderUtils.assertThat(eventProcessorName, name -> Objects.nonNull(name) && !"".equals(name), exceptionMessage);
    }

    public String name() {
        return this.name;
    }

    public EventHandlerInvoker eventHandlerInvoker() {
        return this.eventHandlerInvoker;
    }

    public ErrorHandler errorHandler() {
        return this.errorHandler;
    }

    public MessageMonitor<? super EventMessage<?>> messageMonitor() {
        return this.messageMonitor;
    }

    public EventProcessorSpanFactory spanFactory() {
        return this.spanFactory;
    }
}

