/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline;

import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.deadline.AbstractDeadlineManager;
import org.axonframework.deadline.DeadlineManagerSpanFactory;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.DefaultDeadlineManagerSpanFactory;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.ExecutionException;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.unitofwork.LegacyDefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.tracing.NoOpSpanFactory;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDeadlineManager
extends AbstractDeadlineManager {
    private static final Logger logger = LoggerFactory.getLogger(SimpleDeadlineManager.class);
    private static final String THREAD_FACTORY_GROUP_NAME = "deadlineManager";
    private final ScopeAwareProvider scopeAwareProvider;
    private final ScheduledExecutorService scheduledExecutorService;
    private final TransactionManager transactionManager;
    private final DeadlineManagerSpanFactory spanFactory;
    private final Map<DeadlineId, Future<?>> scheduledTasks = new ConcurrentHashMap();

    public static Builder builder() {
        return new Builder();
    }

    protected SimpleDeadlineManager(Builder builder) {
        builder.validate();
        this.scopeAwareProvider = builder.scopeAwareProvider;
        this.scheduledExecutorService = builder.scheduledExecutorService;
        this.transactionManager = builder.transactionManager;
        this.spanFactory = builder.spanFactory;
        this.messageTypeResolver = builder.messageTypeResolver;
    }

    @Override
    public String schedule(@Nonnull Instant triggerDateTime, @Nonnull String deadlineName, Object messageOrPayload, @Nonnull ScopeDescriptor deadlineScope) {
        DeadlineMessage deadlineMessage = this.asDeadlineMessage(deadlineName, messageOrPayload, triggerDateTime);
        String deadlineMessageId = deadlineMessage.getIdentifier();
        DeadlineId deadlineId = new DeadlineId(deadlineName, deadlineScope, deadlineMessageId);
        Span span = this.spanFactory.createScheduleSpan(deadlineName, deadlineMessageId, deadlineMessage);
        this.runOnPrepareCommitOrNow(span.wrapRunnable(() -> {
            DeadlineMessage interceptedDeadlineMessage = this.processDispatchInterceptors(deadlineMessage);
            DeadlineTask deadlineTask = new DeadlineTask(deadlineId, interceptedDeadlineMessage);
            Duration triggerDuration = Duration.between(Instant.now(), triggerDateTime);
            ScheduledFuture<?> scheduledFuture = this.scheduledExecutorService.schedule(deadlineTask, triggerDuration.toMillis(), TimeUnit.MILLISECONDS);
            this.scheduledTasks.put(deadlineId, scheduledFuture);
        }));
        return deadlineMessageId;
    }

    @Override
    public void cancelSchedule(@Nonnull String deadlineName, @Nonnull String scheduleId) {
        Span span = this.spanFactory.createCancelScheduleSpan(deadlineName, scheduleId);
        this.runOnPrepareCommitOrNow(span.wrapRunnable(() -> this.scheduledTasks.keySet().stream().filter(scheduledTaskId -> scheduledTaskId.getDeadlineName().equals(deadlineName) && scheduledTaskId.getDeadlineId().equals(scheduleId)).forEach(this::cancelSchedule)));
    }

    @Override
    public void cancelAll(@Nonnull String deadlineName) {
        Span span = this.spanFactory.createCancelAllSpan(deadlineName);
        this.runOnPrepareCommitOrNow(span.wrapRunnable(() -> this.scheduledTasks.keySet().stream().filter(scheduledTaskId -> scheduledTaskId.getDeadlineName().equals(deadlineName)).forEach(this::cancelSchedule)));
    }

    @Override
    public void cancelAllWithinScope(@Nonnull String deadlineName, @Nonnull ScopeDescriptor scope) {
        Span span = this.spanFactory.createCancelAllWithinScopeSpan(deadlineName, scope);
        this.runOnPrepareCommitOrNow(span.wrapRunnable(() -> this.scheduledTasks.keySet().stream().filter(scheduledTaskId -> scheduledTaskId.getDeadlineName().equals(deadlineName) && scheduledTaskId.getDeadlineScope().equals(scope)).forEach(this::cancelSchedule)));
    }

    private void cancelSchedule(DeadlineId deadlineId) {
        Future<?> future = this.scheduledTasks.remove(deadlineId);
        if (future != null) {
            future.cancel(false);
        }
    }

    @Override
    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }

    public static class Builder {
        private ScopeAwareProvider scopeAwareProvider;
        private ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new AxonThreadFactory("deadlineManager"));
        private TransactionManager transactionManager = NoTransactionManager.INSTANCE;
        private DeadlineManagerSpanFactory spanFactory = DefaultDeadlineManagerSpanFactory.builder().spanFactory(NoOpSpanFactory.INSTANCE).build();
        private MessageTypeResolver messageTypeResolver = new ClassBasedMessageTypeResolver();

        public Builder scopeAwareProvider(@Nonnull ScopeAwareProvider scopeAwareProvider) {
            BuilderUtils.assertNonNull(scopeAwareProvider, "ScopeAwareProvider may not be null");
            this.scopeAwareProvider = scopeAwareProvider;
            return this;
        }

        public Builder scheduledExecutorService(@Nonnull ScheduledExecutorService scheduledExecutorService) {
            BuilderUtils.assertNonNull(scheduledExecutorService, "ScheduledExecutorService may not be null");
            this.scheduledExecutorService = scheduledExecutorService;
            return this;
        }

        public Builder transactionManager(@Nonnull TransactionManager transactionManager) {
            BuilderUtils.assertNonNull(transactionManager, "TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder spanFactory(@Nonnull DeadlineManagerSpanFactory spanFactory) {
            BuilderUtils.assertNonNull(spanFactory, "SpanFactory may not be null");
            this.spanFactory = spanFactory;
            return this;
        }

        public Builder messageNameResolver(MessageTypeResolver messageTypeResolver) {
            BuilderUtils.assertNonNull(messageTypeResolver, "MessageNameResolver may not be null");
            this.messageTypeResolver = messageTypeResolver;
            return this;
        }

        public SimpleDeadlineManager build() {
            return new SimpleDeadlineManager(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.scopeAwareProvider, "The ScopeAwareProvider is a hard requirement and should be provided");
        }
    }

    private static class DeadlineId {
        private final String deadlineName;
        private final ScopeDescriptor deadlineScope;
        private final String deadlineId;

        private DeadlineId(@Nonnull String deadlineName, @Nonnull ScopeDescriptor deadlineScope, @Nonnull String deadlineId) {
            this.deadlineScope = deadlineScope;
            this.deadlineId = deadlineId;
            this.deadlineName = deadlineName;
        }

        public String getDeadlineName() {
            return this.deadlineName;
        }

        public ScopeDescriptor getDeadlineScope() {
            return this.deadlineScope;
        }

        public String getDeadlineId() {
            return this.deadlineId;
        }

        public int hashCode() {
            return Objects.hash(this.deadlineName, this.deadlineScope, this.deadlineId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DeadlineId other = (DeadlineId)obj;
            return Objects.equals(this.deadlineName, other.deadlineName) && Objects.equals(this.deadlineScope, other.deadlineScope) && Objects.equals(this.deadlineId, other.deadlineId);
        }

        public String toString() {
            return "DeadlineId{deadlineName='" + this.deadlineName + "'deadlineScope=" + String.valueOf(this.deadlineScope) + "', deadlineId='" + this.deadlineId + "'}";
        }
    }

    private class DeadlineTask
    implements Runnable {
        private final DeadlineId deadlineId;
        private final DeadlineMessage<?> deadlineMessage;

        private DeadlineTask(DeadlineId deadlineId, DeadlineMessage<?> deadlineMessage) {
            this.deadlineMessage = deadlineMessage;
            this.deadlineId = deadlineId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug("Triggered deadline");
            }
            Span span = SimpleDeadlineManager.this.spanFactory.createExecuteSpan(this.deadlineId.deadlineName, this.deadlineId.deadlineId, this.deadlineMessage).start();
            try (SpanScope unused = span.makeCurrent();){
                Instant triggerInstant = GenericEventMessage.clock.instant();
                LegacyDefaultUnitOfWork unitOfWork = new LegacyDefaultUnitOfWork(new GenericDeadlineMessage(this.deadlineId.getDeadlineName(), this.deadlineMessage, () -> triggerInstant));
                unitOfWork.onRollback(uow -> span.recordException(uow.getExecutionResult().getExceptionResult()));
                unitOfWork.attachTransaction(SimpleDeadlineManager.this.transactionManager);
                DefaultInterceptorChain chain = new DefaultInterceptorChain(unitOfWork, SimpleDeadlineManager.this.handlerInterceptors(), (deadlineMessage, ctx) -> {
                    this.executeScheduledDeadline((DeadlineMessage)deadlineMessage, ctx, this.deadlineId.getDeadlineScope());
                    return null;
                });
                ResultMessage<Object> resultMessage = unitOfWork.executeWithResult(chain::proceedSync);
                if (resultMessage.isExceptional()) {
                    Throwable e = resultMessage.exceptionResult();
                    logger.error("An error occurred while triggering the deadline [{}] with identifier [{}]", new Object[]{this.deadlineId.getDeadlineName(), this.deadlineId.getDeadlineId(), e});
                }
            }
            catch (Exception e) {
                span.recordException(e);
                logger.error("An error occurred while triggering the deadline [{}] with identifier [{}]", new Object[]{this.deadlineId.getDeadlineName(), this.deadlineId.getDeadlineId(), e});
            }
            finally {
                span.end();
                SimpleDeadlineManager.this.scheduledTasks.remove(this.deadlineId);
            }
        }

        private void executeScheduledDeadline(DeadlineMessage deadlineMessage, ProcessingContext context, ScopeDescriptor deadlineScope) {
            SimpleDeadlineManager.this.scopeAwareProvider.provideScopeAwareStream(deadlineScope).filter(scopeAwareComponent -> scopeAwareComponent.canResolve(deadlineScope)).forEach(scopeAwareComponent -> {
                try {
                    scopeAwareComponent.send(deadlineMessage, context, deadlineScope);
                }
                catch (Exception e) {
                    String exceptionMessage = String.format("Failed to send a DeadlineMessage for scope [%s]", deadlineScope.scopeDescription());
                    throw new ExecutionException(exceptionMessage, e);
                }
            });
        }
    }
}

