/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.eventhandling.gateway.DefaultEventGateway;
import org.axonframework.eventhandling.gateway.EventGateway;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.unitofwork.ProcessingLifecycleHandlerRegistrar;
import org.axonframework.queryhandling.DefaultQueryGateway;
import org.axonframework.queryhandling.LoggingQueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryInvocationErrorHandler;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.SimpleQueryBus;
import org.axonframework.queryhandling.SimpleQueryUpdateEmitter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.json.JacksonConverter;

public class MessagingConfigurationDefaults
implements ConfigurationEnhancer {
    @Override
    public int order() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void enhance(@Nonnull ComponentRegistry registry) {
        registry.registerIfNotPresent(MessageTypeResolver.class, MessagingConfigurationDefaults::defaultMessageTypeResolver).registerIfNotPresent(Converter.class, c -> new JacksonConverter()).registerIfNotPresent(CommandGateway.class, MessagingConfigurationDefaults::defaultCommandGateway).registerIfNotPresent(CommandBus.class, MessagingConfigurationDefaults::defaultCommandBus).registerIfNotPresent(EventGateway.class, MessagingConfigurationDefaults::defaultEventGateway).registerIfNotPresent(EventSink.class, MessagingConfigurationDefaults::defaultEventSink).registerIfNotPresent(EventBus.class, MessagingConfigurationDefaults::defaultEventBus).registerIfNotPresent(QueryGateway.class, MessagingConfigurationDefaults::defaultQueryGateway).registerIfNotPresent(QueryBus.class, MessagingConfigurationDefaults::defaultQueryBus).registerIfNotPresent(QueryUpdateEmitter.class, MessagingConfigurationDefaults::defaultQueryUpdateEmitter);
    }

    private static MessageTypeResolver defaultMessageTypeResolver(Configuration config) {
        return new ClassBasedMessageTypeResolver();
    }

    private static CommandBus defaultCommandBus(Configuration config) {
        return config.getOptionalComponent(TransactionManager.class).map(xva$0 -> new SimpleCommandBus((ProcessingLifecycleHandlerRegistrar)xva$0)).orElse(new SimpleCommandBus(new ProcessingLifecycleHandlerRegistrar[0]));
    }

    private static CommandGateway defaultCommandGateway(Configuration config) {
        return new DefaultCommandGateway(config.getComponent(CommandBus.class), config.getComponent(MessageTypeResolver.class));
    }

    private static EventBus defaultEventBus(Configuration config) {
        return SimpleEventBus.builder().build();
    }

    private static EventSink defaultEventSink(Configuration config) {
        EventBus eventBus = config.getComponent(EventBus.class);
        return (context, events) -> {
            eventBus.publish(events);
            return FutureUtils.emptyCompletedFuture();
        };
    }

    private static EventGateway defaultEventGateway(Configuration config) {
        return new DefaultEventGateway(config.getComponent(EventSink.class), config.getComponent(MessageTypeResolver.class));
    }

    private static QueryGateway defaultQueryGateway(Configuration config) {
        return DefaultQueryGateway.builder().queryBus(config.getComponent(QueryBus.class)).build();
    }

    private static QueryBus defaultQueryBus(Configuration config) {
        return SimpleQueryBus.builder().transactionManager(config.getComponent(TransactionManager.class, NoTransactionManager::instance)).errorHandler(config.getComponent(QueryInvocationErrorHandler.class, () -> LoggingQueryInvocationErrorHandler.builder().build())).queryUpdateEmitter(config.getComponent(QueryUpdateEmitter.class)).build();
    }

    private static QueryUpdateEmitter defaultQueryUpdateEmitter(Configuration config) {
        return SimpleQueryUpdateEmitter.builder().build();
    }
}

