/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import jakarta.annotation.Nullable;
import java.util.Objects;

public abstract class StringUtils {
    private static final String EMPTY_STRING = "";

    private StringUtils() {
    }

    public static boolean nonEmptyOrNull(String s) {
        return Objects.nonNull(s) && !EMPTY_STRING.equals(s);
    }

    public static boolean emptyOrNull(String s) {
        return Objects.isNull(s) || EMPTY_STRING.equals(s);
    }

    public static boolean nonEmpty(String s) {
        return !EMPTY_STRING.equals(s);
    }

    public static String lowerCaseFirstCharacterOf(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public static String capitalize(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }
}

