/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.Optional;
import java.util.function.Predicate;
import org.axonframework.common.AxonNonTransientException;

public abstract class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static Optional<Throwable> findException(Throwable exception, Predicate<Throwable> predicate) {
        for (Throwable result = exception; result != null; result = result.getCause()) {
            if (!predicate.test(result)) continue;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static <T extends Throwable> Optional<T> findException(Throwable exception, Class<T> exceptionClass) {
        return ExceptionUtils.findException(exception, exceptionClass::isInstance).map(e -> e);
    }

    public static boolean isExplicitlyNonTransient(Throwable failure) {
        return failure instanceof AxonNonTransientException || failure.getCause() != null && ExceptionUtils.isExplicitlyNonTransient(failure.getCause());
    }
}

