/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.message.BinaryMessageEncoder;
import org.axonframework.serialization.CannotConvertBetweenTypesException;
import org.axonframework.serialization.ContentTypeConverter;
import org.axonframework.serialization.avro.AvroUtil;

public class GenericRecordToByteArrayConverter
implements ContentTypeConverter<GenericRecord, byte[]> {
    @Override
    public Class<GenericRecord> expectedSourceType() {
        return GenericRecord.class;
    }

    @Override
    public Class<byte[]> targetType() {
        return byte[].class;
    }

    @Override
    public byte[] convert(GenericRecord genericRecord) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            new BinaryMessageEncoder(AvroUtil.genericData, genericRecord.getSchema()).encode((Object)genericRecord, (OutputStream)baos);
            baos.flush();
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new CannotConvertBetweenTypesException("Cannot convert GenericRecord to bytes", e);
            }
        }
        baos.close();
        return byArray;
    }
}

