/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.axonframework.common.Registration;
import org.axonframework.messaging.MessageDispatchInterceptorSupport;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptorSupport;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.QueryUpdateEmitter;
import org.axonframework.queryhandling.StreamingQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryResult;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.concurrent.Queues;

public interface QueryBus
extends MessageHandlerInterceptorSupport<QueryMessage<?, ?>>,
MessageDispatchInterceptorSupport<QueryMessage<?, ?>> {
    public <R> Registration subscribe(@Nonnull String var1, @Nonnull Type var2, @Nonnull MessageHandler<? super QueryMessage<?, R>, ? extends QueryResponseMessage<?>> var3);

    public <Q, R> CompletableFuture<QueryResponseMessage<R>> query(@Nonnull QueryMessage<Q, R> var1);

    default public <Q, R> Publisher<QueryResponseMessage<R>> streamingQuery(StreamingQueryMessage<Q, R> query) {
        throw new UnsupportedOperationException("Streaming query is not supported by this QueryBus.");
    }

    public <Q, R> Stream<QueryResponseMessage<R>> scatterGather(@Nonnull QueryMessage<Q, R> var1, long var2, @Nonnull TimeUnit var4);

    default public <Q, I, U> SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>> subscriptionQuery(@Nonnull SubscriptionQueryMessage<Q, I, U> query) {
        return this.subscriptionQuery(query, Queues.SMALL_BUFFER_SIZE);
    }

    default public <Q, I, U> SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>> subscriptionQuery(final @Nonnull SubscriptionQueryMessage<Q, I, U> query, int updateBufferSize) {
        return new SubscriptionQueryResult<QueryResponseMessage<I>, SubscriptionQueryUpdateMessage<U>>(){

            @Override
            public Mono<QueryResponseMessage<I>> initialResult() {
                return Mono.fromFuture(() -> QueryBus.this.query(query));
            }

            @Override
            public Flux<SubscriptionQueryUpdateMessage<U>> updates() {
                return Flux.empty();
            }

            @Override
            public boolean cancel() {
                return true;
            }
        };
    }

    public QueryUpdateEmitter queryUpdateEmitter();
}

