/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import jakarta.annotation.Nonnull;
import java.util.Map;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDecorator;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.queryhandling.QueryMessage;

public class GenericQueryMessage<P, R>
extends MessageDecorator<P>
implements QueryMessage<P, R> {
    private final ResponseType<R> responseType;

    public GenericQueryMessage(@Nonnull MessageType type, @Nonnull P payload, @Nonnull ResponseType<R> responseType) {
        this(new GenericMessage<P>(type, payload, MetaData.emptyInstance()), responseType);
    }

    public GenericQueryMessage(@Nonnull Message<P> delegate, @Nonnull ResponseType<R> responseType) {
        super(delegate);
        this.responseType = responseType;
    }

    @Override
    public ResponseType<R> getResponseType() {
        return this.responseType;
    }

    @Override
    public QueryMessage<P, R> withMetaData(@Nonnull Map<String, ?> metaData) {
        return new GenericQueryMessage(this.getDelegate().withMetaData(metaData), this.responseType);
    }

    @Override
    public QueryMessage<P, R> andMetaData(@Nonnull Map<String, ?> metaData) {
        return new GenericQueryMessage(this.getDelegate().andMetaData(metaData), this.responseType);
    }

    @Override
    protected void describeTo(StringBuilder stringBuilder) {
        super.describeTo(stringBuilder);
        stringBuilder.append(", expectedResponseType='").append(this.getResponseType()).append('\'');
    }

    @Override
    protected String describeType() {
        return "GenericQueryMessage";
    }
}

