/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.timeout;

import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.timeout.AxonTaskJanitor;
import org.axonframework.messaging.timeout.AxonTimeLimitedTask;
import org.axonframework.messaging.unitofwork.LegacyUnitOfWork;
import org.slf4j.Logger;

public class UnitOfWorkTimeoutInterceptor
implements MessageHandlerInterceptor<Message<?>> {
    private static final String TRANSACTION_TIME_LIMIT_RESOURCE_KEY = "_transactionTimeLimit";
    private final String componentName;
    private final int timeout;
    private final int warningThreshold;
    private final int warningInterval;
    private final ScheduledExecutorService executorService;
    private final Logger logger;

    public UnitOfWorkTimeoutInterceptor(String componentName, int timeout, int warningThreshold, int warningInterval) {
        this(componentName, timeout, warningThreshold, warningInterval, AxonTaskJanitor.INSTANCE, AxonTaskJanitor.LOGGER);
    }

    public UnitOfWorkTimeoutInterceptor(String componentName, int timeout, int warningThreshold, int warningInterval, ScheduledExecutorService executorService, Logger logger) {
        this.componentName = componentName;
        this.timeout = timeout;
        this.warningThreshold = warningThreshold;
        this.warningInterval = warningInterval;
        this.executorService = executorService;
        this.logger = logger;
    }

    @Override
    public Object handle(@Nonnull LegacyUnitOfWork<? extends Message<?>> unitOfWork, @Nonnull InterceptorChain interceptorChain) throws Exception {
        LegacyUnitOfWork<?> root = unitOfWork.root();
        if (!root.resources().containsKey(TRANSACTION_TIME_LIMIT_RESOURCE_KEY)) {
            AxonTimeLimitedTask taskTimeout = new AxonTimeLimitedTask("UnitOfWork of " + this.componentName, this.timeout, this.warningThreshold, this.warningInterval, this.executorService, this.logger);
            root.resources().put(TRANSACTION_TIME_LIMIT_RESOURCE_KEY, taskTimeout);
            taskTimeout.start();
            unitOfWork.afterCommit(u -> taskTimeout.complete());
            unitOfWork.onRollback(u -> taskTimeout.complete());
        }
        return interceptorChain.proceedSync();
    }
}

